/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.uima.ae.AEProviderFactory;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class BaseUIMATokenizer
extends Tokenizer {
    protected FSIterator<AnnotationFS> iterator;
    protected final AnalysisEngine ae;
    protected final CAS cas;

    protected BaseUIMATokenizer(Reader reader, String descriptorPath) {
        super(reader);
        try {
            this.ae = AEProviderFactory.getInstance().getAEProvider(descriptorPath).getAE();
            this.cas = this.ae.newCAS();
        }
        catch (ResourceInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyzeInput() throws AnalysisEngineProcessException, IOException {
        this.cas.reset();
        this.cas.setDocumentText(this.toString(this.input));
        this.ae.process(this.cas);
    }

    protected abstract void initializeIterator() throws IOException;

    private String toString(Reader reader) throws IOException {
        int ch;
        StringBuilder stringBuilder = new StringBuilder();
        while ((ch = reader.read()) > -1) {
            stringBuilder.append((char)ch);
        }
        return stringBuilder.toString();
    }

    public void setReader(Reader input) throws IOException {
        super.setReader(input);
        this.iterator = null;
    }

    public void end() throws IOException {
        this.iterator = null;
    }
}

