/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko.dict;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class UserDictionary
implements Dictionary {
    private final TokenInfoFST fst;
    public static final int WORD_COST = -100000;
    public static final short LEFT_ID = 1781;
    public static final short RIGHT_ID = 3534;
    public static final short RIGHT_ID_T = 3534;
    public static final short RIGHT_ID_F = 3535;
    private final int[][] segmentations;
    private final short[] rightIds;

    public static UserDictionary open(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        ArrayList<String> entries = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.replaceAll("#.*$", "")).trim().length() == 0) continue;
            entries.add(line);
        }
        if (entries.isEmpty()) {
            return null;
        }
        return new UserDictionary(entries);
    }

    private UserDictionary(List<String> entries) throws IOException {
        CharacterDefinition charDef = CharacterDefinition.getInstance();
        Collections.sort(entries, Comparator.comparing(e -> e.split("\\s+")[0]));
        PositiveIntOutputs fstOutput = PositiveIntOutputs.getSingleton();
        Builder fstBuilder = new Builder(FST.INPUT_TYPE.BYTE2, (Outputs)fstOutput);
        IntsRefBuilder scratch = new IntsRefBuilder();
        String lastToken = null;
        ArrayList<int[]> segmentations = new ArrayList<int[]>(entries.size());
        ArrayList<Short> rightIds = new ArrayList<Short>(entries.size());
        long ord = 0L;
        for (String entry : entries) {
            String[] splits = entry.split("\\s+");
            String token = splits[0];
            if (lastToken != null && token.equals(lastToken)) continue;
            char lastChar = entry.charAt(entry.length() - 1);
            if (charDef.isHangul(lastChar)) {
                if (charDef.hasCoda(lastChar)) {
                    rightIds.add((short)3534);
                } else {
                    rightIds.add((short)3535);
                }
            } else {
                rightIds.add((short)3534);
            }
            if (splits.length == 1) {
                segmentations.add(null);
            } else {
                int[] length = new int[splits.length - 1];
                int offset = 0;
                for (int i = 1; i < splits.length; ++i) {
                    length[i - 1] = splits[i].length();
                    offset += splits[i].length();
                }
                if (offset > token.length()) {
                    throw new IllegalArgumentException("Illegal user dictionary entry " + entry + " - the segmentation is bigger than the surface form (" + token + ")");
                }
                segmentations.add(length);
            }
            scratch.grow(token.length());
            scratch.setLength(token.length());
            for (int i = 0; i < token.length(); ++i) {
                scratch.setIntAt(i, (int)token.charAt(i));
            }
            fstBuilder.add(scratch.get(), (Object)ord);
            lastToken = token;
            ++ord;
        }
        this.fst = new TokenInfoFST((FST<Long>)fstBuilder.finish());
        this.segmentations = (int[][])segmentations.toArray((T[])new int[segmentations.size()][]);
        this.rightIds = new short[rightIds.size()];
        for (int i = 0; i < rightIds.size(); ++i) {
            this.rightIds[i] = (Short)rightIds.get(i);
        }
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    @Override
    public int getLeftId(int wordId) {
        return 1781;
    }

    @Override
    public int getRightId(int wordId) {
        return this.rightIds[wordId];
    }

    @Override
    public int getWordCost(int wordId) {
        return -100000;
    }

    @Override
    public POS.Type getPOSType(int wordId) {
        if (this.segmentations[wordId] == null) {
            return POS.Type.MORPHEME;
        }
        return POS.Type.COMPOUND;
    }

    @Override
    public POS.Tag getLeftPOS(int wordId) {
        return POS.Tag.NNG;
    }

    @Override
    public POS.Tag getRightPOS(int wordId) {
        return POS.Tag.NNG;
    }

    @Override
    public String getReading(int wordId) {
        return null;
    }

    @Override
    public Dictionary.Morpheme[] getMorphemes(int wordId, char[] surfaceForm, int off, int len) {
        int[] segs = this.segmentations[wordId];
        if (segs == null) {
            return null;
        }
        int offset = 0;
        Dictionary.Morpheme[] morphemes = new Dictionary.Morpheme[segs.length];
        for (int i = 0; i < segs.length; ++i) {
            morphemes[i] = new Dictionary.Morpheme(POS.Tag.NNG, new String(surfaceForm, off + offset, segs[i]));
            offset += segs[i];
        }
        return morphemes;
    }

    public List<Integer> lookup(char[] chars, int off, int len) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        FST.BytesReader fstReader = this.fst.getBytesReader();
        FST.Arc<Long> arc = new FST.Arc<Long>();
        int end = off + len;
        for (int startOffset = off; startOffset < end; ++startOffset) {
            char ch;
            arc = this.fst.getFirstArc(arc);
            int output = 0;
            int remaining = end - startOffset;
            for (int i = 0; i < remaining && this.fst.findTargetArc(ch = chars[startOffset + i], arc, arc, i == 0, fstReader) != null; ++i) {
                output += ((Long)arc.output).intValue();
                if (!arc.isFinal()) continue;
                int finalOutput = output + ((Long)arc.nextFinalOutput).intValue();
                result.add(finalOutput);
            }
        }
        return result;
    }
}

