/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.morfologik;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.morfologik.MorphosyntacticTagsAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.Version;

public class MorfologikFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final MorphosyntacticTagsAttribute tagsAtt = (MorphosyntacticTagsAttribute)this.addAttribute(MorphosyntacticTagsAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAttr = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final CharsRef scratch = new CharsRef(0);
    private final CharacterUtils charUtils;
    private AttributeSource.State current;
    private final TokenStream input;
    private final IStemmer stemmer;
    private List<WordData> lemmaList;
    private final ArrayList<StringBuilder> tagsList = new ArrayList();
    private int lemmaListIndex;
    private static final Pattern lemmaSplitter = Pattern.compile("\\+|\\|");

    public MorfologikFilter(TokenStream in, Version version) {
        this(in, "pl", version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MorfologikFilter(TokenStream in, String dict, Version version) {
        super(in);
        this.input = in;
        Thread me = Thread.currentThread();
        ClassLoader cl = me.getContextClassLoader();
        try {
            me.setContextClassLoader(Dictionary.class.getClassLoader());
            this.stemmer = new DictionaryLookup(Dictionary.getForLanguage((String)dict));
            this.charUtils = CharacterUtils.getInstance((Version)version);
            this.lemmaList = Collections.emptyList();
        }
        finally {
            me.setContextClassLoader(cl);
        }
    }

    private void popNextLemma() {
        WordData lemma = this.lemmaList.get(this.lemmaListIndex++);
        this.termAtt.setEmpty().append(lemma.getStem());
        CharSequence tag = lemma.getTag();
        if (tag != null) {
            String[] tags = lemmaSplitter.split(tag.toString());
            for (int i = 0; i < tags.length; ++i) {
                if (this.tagsList.size() <= i) {
                    this.tagsList.add(new StringBuilder());
                }
                StringBuilder buffer = this.tagsList.get(i);
                buffer.setLength(0);
                buffer.append(tags[i]);
            }
            this.tagsAtt.setTags(this.tagsList.subList(0, tags.length));
        } else {
            this.tagsAtt.setTags(Collections.emptyList());
        }
    }

    private boolean lookupSurfaceForm(CharSequence token) {
        this.lemmaList = this.stemmer.lookup(token);
        this.lemmaListIndex = 0;
        return this.lemmaList.size() > 0;
    }

    public final boolean incrementToken() throws IOException {
        if (this.lemmaListIndex < this.lemmaList.size()) {
            this.restoreState(this.current);
            this.posIncrAtt.setPositionIncrement(0);
            this.popNextLemma();
            return true;
        }
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword() && (this.lookupSurfaceForm((CharSequence)this.termAtt) || this.lookupSurfaceForm(this.toLowercase((CharSequence)this.termAtt)))) {
                this.current = this.captureState();
                this.popNextLemma();
            } else {
                this.tagsAtt.clear();
            }
            return true;
        }
        return false;
    }

    private CharSequence toLowercase(CharSequence chs) {
        int length = this.scratch.length = chs.length();
        this.scratch.grow(length);
        char[] buffer = this.scratch.chars;
        for (int i = 0; i < length; i += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(chs, i)), buffer, i)) {
        }
        return this.scratch;
    }

    public void reset() throws IOException {
        this.lemmaListIndex = 0;
        this.lemmaList = Collections.emptyList();
        this.tagsList.clear();
        super.reset();
    }
}

