/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class ConnectionCosts {
    public static final String FILENAME_SUFFIX = ".dat";
    public static final String HEADER = "kuromoji_cc";
    public static final int VERSION = 1;
    private final ByteBuffer buffer;
    private final int forwardSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionCosts(BinaryDictionary.ResourceScheme scheme, String path) throws IOException {
        block7: {
            InputStream is;
            block6: {
                is = null;
                boolean success = false;
                try {
                    is = BinaryDictionary.getResource(scheme, path.replace('.', '/') + FILENAME_SUFFIX);
                    is = new BufferedInputStream(is);
                    InputStreamDataInput in = new InputStreamDataInput(is);
                    CodecUtil.checkHeader((DataInput)in, (String)HEADER, (int)1, (int)1);
                    this.forwardSize = in.readVInt();
                    int backwardSize = in.readVInt();
                    int size = this.forwardSize * backwardSize;
                    ByteBuffer tmpBuffer = ByteBuffer.allocateDirect(size * 2);
                    int accum = 0;
                    for (int j = 0; j < backwardSize; ++j) {
                        for (int i = 0; i < this.forwardSize; ++i) {
                            tmpBuffer.putShort((short)(accum += in.readZInt()));
                        }
                    }
                    this.buffer = tmpBuffer.asReadOnlyBuffer();
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{is});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{is});
                break block7;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
        }
    }

    private ConnectionCosts() throws IOException {
        this(BinaryDictionary.ResourceScheme.CLASSPATH, ConnectionCosts.class.getName());
    }

    public int get(int forwardId, int backwardId) {
        int offset = (backwardId * this.forwardSize + forwardId) * 2;
        return this.buffer.getShort(offset);
    }

    public static ConnectionCosts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final ConnectionCosts INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new ConnectionCosts();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load ConnectionCosts.", ioe);
            }
        }
    }
}

