/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthCharFilter;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;

public class JapaneseAnalyzer
extends StopwordAnalyzerBase {
    private final JapaneseTokenizer.Mode mode;
    private final Set<String> stoptags;
    private final UserDictionary userDict;

    public JapaneseAnalyzer() {
        this(null, JapaneseTokenizer.DEFAULT_MODE, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS);
    }

    public JapaneseAnalyzer(UserDictionary userDict, JapaneseTokenizer.Mode mode, CharArraySet stopwords, Set<String> stoptags) {
        super(stopwords);
        this.userDict = userDict;
        this.mode = mode;
        this.stoptags = stoptags;
    }

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public static Set<String> getDefaultStopTags() {
        return DefaultSetHolder.DEFAULT_STOP_TAGS;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.userDict, true, true, this.mode);
        Object stream = new JapaneseBaseFormFilter((TokenStream)tokenizer);
        stream = new JapanesePartOfSpeechStopFilter((TokenStream)stream, this.stoptags);
        stream = new StopFilter((TokenStream)stream, this.stopwords);
        stream = new JapaneseKatakanaStemFilter((TokenStream)stream);
        stream = new LowerCaseFilter((TokenStream)stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        LowerCaseFilter result = new LowerCaseFilter(in);
        return result;
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return new CJKWidthCharFilter(reader);
    }

    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        return new CJKWidthCharFilter(reader);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = JapaneseAnalyzer.loadStopwordSet((boolean)true, (Class)JapaneseAnalyzer.class, (String)"stopwords.txt", (String)"#");
                CharArraySet tagset = JapaneseAnalyzer.loadStopwordSet((boolean)false, (Class)JapaneseAnalyzer.class, (String)"stoptags.txt", (String)"#");
                DEFAULT_STOP_TAGS = new HashSet<String>();
                for (Object element : tagset) {
                    char[] chars = (char[])element;
                    DEFAULT_STOP_TAGS.add(new String(chars));
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword or stoptag set", ex);
            }
        }
    }
}

