/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

public class Log4jServletFilter
implements Filter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    static final String ALREADY_FILTERED_ATTRIBUTE = Log4jServletFilter.class.getName() + ".FILTERED";
    static final ThreadLocal<ServletRequest> CURRENT_REQUEST = new ThreadLocal();
    private ServletContext servletContext;
    private Log4jWebLifeCycle initializer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        LOGGER.debug("Log4jServletFilter initialized.");
        this.initializer = WebLoggerContextUtils.getWebLifeCycle(this.servletContext);
        this.initializer.clearLoggerContext();
        filterConfig.getServletContext().setAttribute("log4j.requestExecutor", (request, command) -> {
            try {
                this.initializer.setLoggerContext();
                CURRENT_REQUEST.set((ServletRequest)request);
                command.run();
            }
            finally {
                this.initializer.clearLoggerContext();
                CURRENT_REQUEST.remove();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_FILTERED_ATTRIBUTE) != null) {
            chain.doFilter(request, response);
        } else {
            request.setAttribute(ALREADY_FILTERED_ATTRIBUTE, (Object)Boolean.TRUE);
            try {
                this.initializer.setLoggerContext();
                CURRENT_REQUEST.set(request);
                chain.doFilter(request, response);
            }
            finally {
                this.initializer.clearLoggerContext();
                CURRENT_REQUEST.remove();
            }
        }
    }

    public void destroy() {
        if (this.servletContext == null || this.initializer == null) {
            throw new IllegalStateException("Filter destroyed before it was initialized.");
        }
        LOGGER.debug("Log4jServletFilter destroyed.");
        this.initializer.setLoggerContext();
    }
}

