/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.weaver;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.weaver.Constants;
import org.apache.logging.log4j.weaver.SupplierLambdaType;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class LocationCacheGenerator {
    private static final Type LAMBDA_UTIL_TYPE = Type.getObjectType((String)"org/apache/logging/log4j/util/LambdaUtil");
    private static final Type STRING_FORMATTER_MESSAGE_FACTORY_TYPE = Type.getObjectType((String)"org/apache/logging/log4j/message/StringFormatterMessageFactory");
    private static final String LOCATION_FIELD = "locations";
    private final Map<String, LocationCacheContents> locationCacheClasses = new ConcurrentHashMap<String, LocationCacheContents>();

    public LocationCacheValue addLocation(String internalClassName, String methodName, String fileName, int lineNumber) {
        String cacheClassName = LocationCacheGenerator.getCacheClassName(internalClassName);
        LocationCacheContents contents = this.locationCacheClasses.computeIfAbsent(cacheClassName, k -> new LocationCacheContents());
        int index = contents.addLocation(internalClassName, methodName, fileName, lineNumber);
        return new LocationCacheValue(cacheClassName, LOCATION_FIELD, index);
    }

    public Handle createLambda(String internalClassName, SupplierLambdaType type) {
        String cacheClassName = LocationCacheGenerator.getCacheClassName(internalClassName);
        LocationCacheContents contents = this.locationCacheClasses.computeIfAbsent(cacheClassName, k -> new LocationCacheContents());
        contents.addLambda(type);
        String methodName = type.name().toLowerCase();
        String methodDescriptor = Type.getMethodDescriptor((Type)Constants.MESSAGE_TYPE, (Type[])type.getArgumentTypes());
        switch (type) {
            case FORMATTED_MESSAGE: 
            case ENTRY_MESSAGE_MESSAGE: 
            case ENTRY_MESSAGE_STRING_OBJECTS: 
            case ENTRY_MESSAGE_STRING_SUPPLIERS: 
            case EXIT_MESSAGE_ENTRY_MESSAGE: 
            case EXIT_MESSAGE_MESSAGE: 
            case EXIT_MESSAGE_OBJECT_ENTRY_MESSAGE: 
            case EXIT_MESSAGE_OBJECT_MESSAGE: 
            case EXIT_MESSAGE_STRING_OBJECT: {
                return new Handle(6, cacheClassName, methodName, methodDescriptor, false);
            }
        }
        throw new IllegalArgumentException();
    }

    public Map<String, byte[]> generateClasses() {
        return this.locationCacheClasses.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, e -> LocationCacheGenerator.generateCacheClass((String)e.getKey(), (LocationCacheContents)e.getValue())));
    }

    private static byte[] generateCacheClass(String innerClassName, LocationCacheContents contents) {
        ClassWriter cv = new ClassWriter(0);
        cv.visit(52, 0, innerClassName, null, Constants.OBJECT_TYPE.getInternalName(), null);
        List<StackTraceElement> locations = contents.getLocations();
        LocationCacheGenerator.writeLocations(innerClassName, (ClassVisitor)cv, locations);
        Set<SupplierLambdaType> lambdas = contents.getLambdas();
        block5: for (SupplierLambdaType type : lambdas) {
            InstructionAdapter mv = new InstructionAdapter(cv.visitMethod(8, type.name().toLowerCase(), type.getImplementationMethodDescriptor(), null, null));
            switch (type) {
                case FORMATTED_MESSAGE: {
                    LocationCacheGenerator.writeFormattedMessage(mv);
                    continue block5;
                }
                case ENTRY_MESSAGE_MESSAGE: 
                case ENTRY_MESSAGE_STRING_OBJECTS: 
                case EXIT_MESSAGE_ENTRY_MESSAGE: 
                case EXIT_MESSAGE_MESSAGE: 
                case EXIT_MESSAGE_OBJECT_ENTRY_MESSAGE: 
                case EXIT_MESSAGE_OBJECT_MESSAGE: 
                case EXIT_MESSAGE_STRING_OBJECT: {
                    LocationCacheGenerator.writeEntryExitMessage(mv, type);
                    continue block5;
                }
                case ENTRY_MESSAGE_STRING_SUPPLIERS: {
                    LocationCacheGenerator.writeEntryMessageSuppliers(mv);
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
        cv.visitEnd();
        return cv.toByteArray();
    }

    private static void writeLocations(String innerClassName, ClassVisitor cv, List<StackTraceElement> locations) {
        cv.visitField(8, LOCATION_FIELD, Constants.STACK_TRACE_ELEMENT_ARRAY_TYPE.getInternalName(), null, null).visitEnd();
        InstructionAdapter mv = new InstructionAdapter(cv.visitMethod(8, "<clinit>", "()V", null, null));
        mv.visitCode();
        mv.visitMaxs(9, 0);
        mv.iconst(locations.size());
        mv.newarray(Constants.STACK_TRACE_ELEMENT_TYPE);
        for (int i = 0; i < locations.size(); ++i) {
            StackTraceElement location = locations.get(i);
            mv.dup();
            mv.iconst(i);
            mv.anew(Constants.STACK_TRACE_ELEMENT_TYPE);
            mv.dup();
            mv.aconst((Object)location.getClassName());
            mv.aconst((Object)location.getMethodName());
            mv.aconst((Object)location.getFileName());
            mv.iconst(location.getLineNumber());
            mv.invokespecial(Constants.STACK_TRACE_ELEMENT_TYPE.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Constants.STRING_TYPE, Constants.STRING_TYPE, Constants.STRING_TYPE, Type.INT_TYPE}), false);
            mv.visitInsn(83);
        }
        mv.putstatic(innerClassName, LOCATION_FIELD, Constants.STACK_TRACE_ELEMENT_ARRAY_TYPE.getInternalName());
        mv.areturn(Type.VOID_TYPE);
        mv.visitEnd();
    }

    private static void writeFormattedMessage(InstructionAdapter mv) {
        mv.visitCode();
        mv.visitMaxs(3, 2);
        mv.getstatic(STRING_FORMATTER_MESSAGE_FACTORY_TYPE.getInternalName(), "INSTANCE", STRING_FORMATTER_MESSAGE_FACTORY_TYPE.getDescriptor());
        mv.load(0, Constants.STRING_TYPE);
        mv.load(1, Constants.OBJECT_ARRAY_TYPE);
        mv.invokevirtual(STRING_FORMATTER_MESSAGE_FACTORY_TYPE.getInternalName(), "newMessage", Type.getMethodType((Type)Constants.MESSAGE_TYPE, (Type[])new Type[]{Constants.STRING_TYPE, Constants.OBJECT_ARRAY_TYPE}).getDescriptor(), false);
        mv.areturn(Constants.MESSAGE_TYPE);
        mv.visitEnd();
    }

    private static void writeEntryExitMessage(InstructionAdapter mv, SupplierLambdaType type) {
        Type[] args = type.getArgumentTypes();
        mv.visitCode();
        mv.visitMaxs(args.length, args.length);
        mv.load(0, Constants.LOGGER_TYPE);
        mv.invokeinterface(Constants.LOGGER_TYPE.getInternalName(), "getFlowMessageFactory", Type.getMethodDescriptor((Type)Constants.FLOW_MESSAGE_FACTORY_TYPE, (Type[])new Type[0]));
        for (int i = 1; i < args.length; ++i) {
            mv.load(i, args[i]);
        }
        boolean isEntry = type.name().startsWith("ENTRY");
        String methodName = isEntry ? "newEntryMessage" : "newExitMessage";
        mv.invokeinterface(Constants.FLOW_MESSAGE_FACTORY_TYPE.getInternalName(), methodName, Type.getMethodDescriptor((Type)(isEntry ? Constants.ENTRY_MESSAGE_TYPE : Constants.EXIT_MESSAGE_TYPE), (Type[])Arrays.copyOfRange(args, 1, args.length)));
        mv.areturn(Constants.MESSAGE_TYPE);
        mv.visitEnd();
    }

    private static void writeEntryMessageSuppliers(InstructionAdapter mv) {
        mv.visitCode();
        mv.visitMaxs(3, 3);
        mv.load(0, Constants.LOGGER_TYPE);
        mv.invokeinterface(Constants.LOGGER_TYPE.getInternalName(), "getFlowMessageFactory", Type.getMethodDescriptor((Type)Constants.FLOW_MESSAGE_FACTORY_TYPE, (Type[])new Type[0]));
        mv.load(1, Constants.STRING_TYPE);
        mv.load(2, Constants.SUPPLIER_ARRAY_TYPE);
        mv.invokestatic(LAMBDA_UTIL_TYPE.getInternalName(), "getAll", Type.getMethodDescriptor((Type)Constants.OBJECT_ARRAY_TYPE, (Type[])new Type[]{Constants.SUPPLIER_ARRAY_TYPE}), false);
        mv.invokeinterface(Constants.FLOW_MESSAGE_FACTORY_TYPE.getInternalName(), "newEntryMessage", Type.getMethodDescriptor((Type)Constants.ENTRY_MESSAGE_TYPE, (Type[])new Type[]{Constants.STRING_TYPE, Constants.OBJECT_ARRAY_TYPE}));
        mv.areturn(Constants.MESSAGE_TYPE);
        mv.visitEnd();
    }

    private static String getCacheClassName(String internalClassName) {
        return StringUtils.substringBefore((String)internalClassName, (int)36) + "$$Log4j2$$Cache";
    }

    public static Path getCacheClassFile(Path classFile) {
        Path fileName = classFile.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("The 'classFile' parameter is an empty path.");
        }
        String cacheFileName = LocationCacheGenerator.getCacheClassName(StringUtils.removeEnd((String)fileName.toString(), (String)".class")) + ".class";
        return classFile.resolveSibling(cacheFileName);
    }

    private static class LocationCacheContents {
        private final List<StackTraceElement> locations = new CopyOnWriteArrayList<StackTraceElement>();
        private Set<SupplierLambdaType> lambdas = EnumSet.noneOf(SupplierLambdaType.class);

        private LocationCacheContents() {
        }

        public int addLocation(String internalClassName, String methodName, String fileName, int lineNumber) {
            StackTraceElement location = new StackTraceElement(internalClassName.replaceAll("/", "."), methodName, fileName, lineNumber);
            this.locations.add(location);
            return this.locations.indexOf(location);
        }

        public List<StackTraceElement> getLocations() {
            return this.locations;
        }

        public boolean addLambda(SupplierLambdaType type) {
            return this.lambdas.add(type);
        }

        public Set<SupplierLambdaType> getLambdas() {
            return this.lambdas;
        }
    }

    public static class LocationCacheValue {
        private final String internalClassName;
        private final String fieldName;
        private final int index;

        private LocationCacheValue(String internalClassName, String fieldName, int index) {
            this.internalClassName = internalClassName;
            this.fieldName = fieldName;
            this.index = index;
        }

        public String getInternalClassName() {
            return this.internalClassName;
        }

        public Type getType() {
            return Type.getObjectType((String)this.internalClassName);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

