/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.transform.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.transform.maven.scan.ClassFileInclusionScanner;
import org.apache.logging.log4j.transform.maven.scan.SimpleInclusionScanner;
import org.apache.logging.log4j.weaver.LocationCacheGenerator;
import org.apache.logging.log4j.weaver.LocationClassConverter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class LocationMojo
extends AbstractMojo {
    private static final String LOG4J_GROUP_ID = "org.apache.logging.log4j";
    private static final String LOG4J_API_ARTIFACT_ID = "log4j-api";
    private static final ArtifactVersion MIN_SUPPORTED_VERSION = new DefaultArtifactVersion("2.20.0");
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=false)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=false)
    private File outputDirectory;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping project with packaging \"pom\".");
            return;
        }
        this.validateLog4jVersion();
        Path sourceDirectory = this.sourceDirectory.toPath();
        Path outputDirectory = this.outputDirectory.toPath();
        LocationCacheGenerator locationCache = new LocationCacheGenerator();
        LocationClassConverter converter = new LocationClassConverter(this.getProjectDependencies());
        try {
            Set<Path> staleClassFiles = this.getClassFileInclusionScanner().getIncludedClassFiles(sourceDirectory, outputDirectory);
            staleClassFiles.stream().collect(Collectors.groupingBy(LocationCacheGenerator::getCacheClassFile)).values().parallelStream().forEach(p -> this.convertClassfiles((List<Path>)p, converter, locationCache));
            locationCache.generateClasses().forEach(this::saveClassFile);
        }
        catch (WrappedIOException e) {
            throw new MojoExecutionException("An I/O error occurred.", e.getCause());
        }
    }

    private void convertClassfiles(List<Path> classFiles, LocationClassConverter converter, LocationCacheGenerator locationCache) {
        Path sourceDirectory = this.sourceDirectory.toPath();
        classFiles.sort(Path::compareTo);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            for (Path classFile : classFiles) {
                buf.reset();
                try (InputStream src = Files.newInputStream(sourceDirectory.resolve(classFile), new OpenOption[0]);){
                    converter.convert(src, (OutputStream)buf, locationCache);
                }
                this.saveClassFile(classFile, buf.toByteArray());
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private void saveClassFile(String internalClassName, byte[] data) {
        try {
            Path outputDirectory = this.outputDirectory.toPath();
            Files.write(outputDirectory.resolve(internalClassName + ".class"), data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private void saveClassFile(Path dest, byte[] data) {
        try {
            Path outputDirectory = this.outputDirectory.toPath();
            Files.write(outputDirectory.resolve(dest), data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    protected ClassFileInclusionScanner getClassFileInclusionScanner() {
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return new SimpleInclusionScanner(this.staleMillis, this.getLog());
        }
        Set<String> actualIncludes = this.includes.isEmpty() ? Collections.singleton("**/*.class") : this.includes;
        HashSet<String> actualExcludes = new HashSet<String>(this.excludes);
        actualExcludes.add("**/*$$Log4j2$$Cache.class");
        return new SimpleInclusionScanner(this.staleMillis, actualIncludes, actualExcludes, this.getLog());
    }

    private void validateLog4jVersion() throws MojoExecutionException {
        Artifact log4jApi = this.project.getArtifacts().stream().filter(a -> LOG4J_GROUP_ID.equals(a.getGroupId()) && LOG4J_API_ARTIFACT_ID.equals(a.getArtifactId())).findAny().orElseThrow(() -> new MojoExecutionException("Missing `log4j-api` dependency."));
        try {
            if (MIN_SUPPORTED_VERSION.compareTo((Object)log4jApi.getSelectedVersion()) > 0) {
                throw new MojoExecutionException("Log4j2 API version " + MIN_SUPPORTED_VERSION + " required. Selected version: " + log4jApi.getSelectedVersion());
            }
            if (!this.project.getDependencyArtifacts().contains(log4jApi)) {
                this.getLog().warn((CharSequence)"Log4j2 API should not be a transitive dependency.");
            }
        }
        catch (OverConstrainedVersionException e) {
            throw new MojoExecutionException("Can not determine `log4j-api` version.", (Exception)((Object)e));
        }
    }

    private ClassLoader getProjectDependencies() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        ArrayList<URL> urls = new ArrayList<URL>(artifacts.size() + 1);
        try {
            urls.add(this.sourceDirectory.toURI().toURL());
            for (Artifact artifact : artifacts) {
                urls.add(artifact.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("An error occurred, while resolving the project's classpath.", (Exception)e);
        }
        return new URLClassLoader(urls.toArray(EMPTY_URL_ARRAY));
    }

    private static class WrappedIOException
    extends RuntimeException {
        private static final long serialVersionUID = 4290527889488735839L;

        private WrappedIOException(IOException cause) {
            super(cause);
        }
    }
}

