/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.logging.log4j.plugins.util;

import java.lang.annotation.Annotation;

/**
 * Pairs an annotation with its meta-annotation. An annotated element may be annotated by an annotation
 * {@code A} which is itself meta-annotated with an annotation {@code M}.
 *
 * @param <A> annotation type
 * @param <M> meta-annotation type
 */
public class AnnotatedAnnotation<A extends Annotation, M extends Annotation> {
    private final A annotation;
    private final M metaAnnotation;

    public AnnotatedAnnotation(final A annotation, final M metaAnnotation) {
        this.annotation = annotation;
        this.metaAnnotation = metaAnnotation;
    }

    public A getAnnotation() {
        return annotation;
    }

    public M getMetaAnnotation() {
        return metaAnnotation;
    }
}
