/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.model.PluginCache;
import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.plugins.model.PluginService;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.plugins.util.ResolverUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.Unbox;

@Singleton
public class PluginRegistry {
    private static final String PLUGIN_CACHE_FILE = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Lazy<Namespaces> mainPluginNamespaces = Lazy.lazy(() -> {
        Namespaces namespaces = this.decodeCacheFiles(LoaderUtil.getClassLoader());
        Throwable throwable = null;
        ClassLoader errorClassLoader = null;
        boolean allFail = true;
        for (ClassLoader classLoader : LoaderUtil.getClassLoaders()) {
            try {
                this.loadPlugins(classLoader, namespaces);
                allFail = false;
            }
            catch (Throwable ex) {
                if (throwable != null) continue;
                throwable = ex;
                errorClassLoader = classLoader;
            }
        }
        if (allFail && throwable != null) {
            LOGGER.debug("Unable to retrieve provider from ClassLoader {}", errorClassLoader, throwable);
        }
        if (namespaces.isEmpty()) {
            this.loadFromPackage(namespaces, "org.apache.logging.log4j.core");
        }
        return namespaces;
    });
    private final Map<Long, Namespaces> namespacesByBundleId = new ConcurrentHashMap<Long, Namespaces>();

    public void clear() {
        this.mainPluginNamespaces.set(null);
        this.namespacesByBundleId.clear();
    }

    public void clearBundlePlugins(long bundleId) {
        this.namespacesByBundleId.remove(bundleId);
    }

    public void loadFromBundle(long bundleId, ClassLoader loader) {
        this.namespacesByBundleId.computeIfAbsent(bundleId, ignored -> {
            Namespaces bundle = this.decodeCacheFiles(loader);
            this.loadPlugins(loader, bundle);
            return bundle;
        });
    }

    public void loadFromBundle(long bundleId, Map<String, PluginNamespace> namespaces) {
        this.namespacesByBundleId.put(bundleId, new Namespaces(namespaces));
    }

    private void loadPlugins(ClassLoader classLoader, Namespaces namespaces) {
        long startTime = System.nanoTime();
        ServiceLoader<PluginService> serviceLoader = ServiceLoader.load(PluginService.class, classLoader);
        AtomicInteger pluginCount = new AtomicInteger();
        for (PluginService pluginService : serviceLoader) {
            pluginService.getNamespaces().values().forEach(category -> pluginCount.addAndGet(namespaces.merge((PluginNamespace)category)));
        }
        int numPlugins = pluginCount.get();
        LOGGER.debug(() -> {
            long endTime = System.nanoTime();
            DecimalFormat numFormat = new DecimalFormat("#0.000000");
            return "Took " + numFormat.format((double)(endTime - startTime) * 1.0E-9) + " seconds to load " + numPlugins + " plugins from " + classLoader;
        });
    }

    private Namespaces decodeCacheFiles(ClassLoader classLoader) {
        long startTime = System.nanoTime();
        PluginCache cache = new PluginCache();
        try {
            Enumeration<URL> resources = classLoader.getResources(PLUGIN_CACHE_FILE);
            if (resources == null) {
                LOGGER.info("Plugin preloads not available from class loader {}", (Object)classLoader);
            } else {
                cache.loadCacheFiles(resources);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to preload plugins", (Throwable)ioe);
        }
        Namespaces namespaces = new Namespaces();
        AtomicInteger pluginCount = new AtomicInteger();
        cache.getAllNamespaces().forEach((key, outer) -> outer.values().forEach(entry -> {
            PluginType type = new PluginType((PluginEntry)entry, classLoader);
            namespaces.add(type);
            pluginCount.incrementAndGet();
        }));
        int numPlugins = pluginCount.get();
        LOGGER.debug(() -> {
            long endTime = System.nanoTime();
            DecimalFormat numFormat = new DecimalFormat("#0.000000");
            return "Took " + numFormat.format((double)(endTime - startTime) * 1.0E-9) + " seconds to load " + numPlugins + " plugins from " + classLoader;
        });
        return namespaces;
    }

    private void loadFromPackage(Namespaces bundle, String pkg) {
        if (Strings.isBlank((String)pkg)) {
            return;
        }
        long startTime = System.nanoTime();
        ResolverUtil resolver = new ResolverUtil();
        ClassLoader classLoader = LoaderUtil.getClassLoader(this.getClass(), LoaderUtil.class);
        if (classLoader != null) {
            resolver.setClassLoader(classLoader);
        }
        resolver.findInPackage(new PluginTest(), pkg);
        for (Class<?> clazz : resolver.getClasses()) {
            String elementType;
            String name = Keys.getName(clazz);
            String namespace = Keys.getNamespace(clazz);
            PluginEntry.Builder builder = PluginEntry.builder().setName(name).setNamespace(namespace).setClassName(clazz.getName());
            Configurable configurable = clazz.getAnnotation(Configurable.class);
            if (configurable != null) {
                elementType = configurable.elementType();
                builder.setElementType(elementType.isEmpty() ? name : elementType).setPrintable(configurable.printObject()).setDeferChildren(configurable.deferChildren());
            } else {
                elementType = "";
            }
            PluginEntry mainEntry = builder.setKey(name.toLowerCase(Locale.ROOT)).get();
            bundle.add(new PluginType(mainEntry, clazz));
            PluginAliases pluginAliases = clazz.getAnnotation(PluginAliases.class);
            if (pluginAliases == null) continue;
            for (String alias : pluginAliases.value()) {
                String aliasElementType = elementType.isEmpty() ? alias : elementType;
                PluginEntry aliasEntry = builder.setKey(alias.toLowerCase(Locale.ROOT)).setElementType(aliasElementType).get();
                bundle.add(new PluginType(aliasEntry, clazz));
            }
        }
        LOGGER.debug(() -> {
            long endTime = System.nanoTime();
            DecimalFormat numFormat = new DecimalFormat("#0.000000");
            return "Took " + numFormat.format((double)(endTime - startTime) * 1.0E-9) + " seconds to load " + resolver.getClasses().size() + " plugins from package " + pkg;
        });
    }

    public PluginNamespace getNamespace(String namespace) {
        PluginNamespace pluginNamespace = new PluginNamespace(namespace);
        Namespaces builtInPlugins = (Namespaces)this.mainPluginNamespaces.value();
        if (builtInPlugins != null) {
            pluginNamespace.mergeAll(builtInPlugins.get(namespace));
        }
        this.namespacesByBundleId.values().forEach(bundle -> pluginNamespace.mergeAll(bundle.get(namespace)));
        LOGGER.debug("Discovered {} plugins in namespace '{}'", (Object)Unbox.box((int)pluginNamespace.size()), (Object)namespace);
        return pluginNamespace;
    }

    private static final class Namespaces
    implements Iterable<PluginNamespace> {
        private final Map<String, PluginNamespace> namespaces;

        private Namespaces() {
            this.namespaces = new LinkedHashMap<String, PluginNamespace>();
        }

        private Namespaces(Map<String, PluginNamespace> namespaces) {
            this.namespaces = namespaces;
        }

        public boolean isEmpty() {
            return this.namespaces.isEmpty();
        }

        public int merge(PluginNamespace category) {
            PluginNamespace existingCategory = this.getOrCreate(category.getKey());
            int added = 0;
            for (PluginType<?> pluginType : category) {
                if (!existingCategory.add(pluginType)) continue;
                ++added;
            }
            return added;
        }

        public void add(PluginType<?> pluginType) {
            this.getOrCreate(pluginType.getNamespace()).put(pluginType);
        }

        public PluginNamespace get(String category) {
            return this.namespaces.get(category.toLowerCase(Locale.ROOT));
        }

        public PluginNamespace getOrCreate(String category) {
            return this.namespaces.computeIfAbsent(category.toLowerCase(Locale.ROOT), key -> new PluginNamespace((String)key, category));
        }

        @Override
        public Iterator<PluginNamespace> iterator() {
            return this.namespaces.values().iterator();
        }
    }

    public static class PluginTest
    implements ResolverUtil.Test {
        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(Plugin.class);
        }

        public String toString() {
            return "annotated with @" + Plugin.class.getSimpleName();
        }

        @Override
        public boolean matches(URI resource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean doesMatchClass() {
            return true;
        }

        @Override
        public boolean doesMatchResource() {
            return false;
        }
    }
}

