/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.convert;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.convert.TypeConverters;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.EnglishEnums;

@Singleton
public class TypeConverterFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Map<Type, TypeConverter<?>> typeConverters = new ConcurrentHashMap();

    @Inject
    public TypeConverterFactory(@TypeConverters List<TypeConverter<?>> typeConverters) {
        typeConverters.forEach(converter -> this.registerTypeConverter(TypeConverterFactory.getTypeConverterSupportedType(converter.getClass()), (TypeConverter<?>)converter));
        this.registerTypeConverter((Type)((Object)Boolean.class), Boolean::valueOf);
        this.registerTypeAlias((Type)((Object)Boolean.class), Boolean.TYPE);
        this.registerTypeConverter((Type)((Object)Byte.class), Byte::valueOf);
        this.registerTypeAlias((Type)((Object)Byte.class), Byte.TYPE);
        this.registerTypeConverter((Type)((Object)Character.class), s -> {
            if (s.length() != 1) {
                throw new IllegalArgumentException("Character string must be of length 1: " + s);
            }
            return Character.valueOf(s.toCharArray()[0]);
        });
        this.registerTypeAlias((Type)((Object)Character.class), Character.TYPE);
        this.registerTypeConverter((Type)((Object)Double.class), Double::valueOf);
        this.registerTypeAlias((Type)((Object)Double.class), Double.TYPE);
        this.registerTypeConverter((Type)((Object)Float.class), Float::valueOf);
        this.registerTypeAlias((Type)((Object)Float.class), Float.TYPE);
        this.registerTypeConverter((Type)((Object)Integer.class), Integer::valueOf);
        this.registerTypeAlias((Type)((Object)Integer.class), Integer.TYPE);
        this.registerTypeConverter((Type)((Object)Long.class), Long::valueOf);
        this.registerTypeAlias((Type)((Object)Long.class), Long.TYPE);
        this.registerTypeConverter((Type)((Object)Short.class), Short::valueOf);
        this.registerTypeAlias((Type)((Object)Short.class), Short.TYPE);
        this.registerTypeConverter((Type)((Object)String.class), s -> s);
    }

    public TypeConverter<?> getTypeConverter(Type type) {
        Class clazz;
        TypeConverter<?> primary = this.typeConverters.get(type);
        if (primary != null) {
            return primary;
        }
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            return this.registerTypeConverter(type, s -> EnglishEnums.valueOf(clazz.asSubclass(Enum.class), (String)s));
        }
        for (Map.Entry<Type, TypeConverter<?>> entry : this.typeConverters.entrySet()) {
            Type key = entry.getKey();
            if (!TypeUtil.isAssignable(type, key)) continue;
            LOGGER.debug("Found compatible TypeConverter<{}> for type [{}].", (Object)key, (Object)type);
            TypeConverter<?> value = entry.getValue();
            return this.registerTypeConverter(type, value);
        }
        throw new UnknownFormatConversionException(type.toString());
    }

    private void registerTypeAlias(Type knownType, Type aliasType) {
        TypeConverter<?> converter = this.typeConverters.get(knownType);
        if (converter != null) {
            this.typeConverters.put(aliasType, converter);
        } else {
            LOGGER.error("Cannot locate type converter for {}", (Object)knownType);
        }
    }

    private TypeConverter<?> registerTypeConverter(Type type, TypeConverter<?> converter) {
        TypeConverter<?> conflictingConverter = this.typeConverters.get(type);
        if (conflictingConverter != null) {
            Comparable comparableConflictingConverter;
            Comparable comparableConverter;
            boolean overridable = converter instanceof Comparable ? (comparableConverter = (Comparable)((Object)converter)).compareTo(conflictingConverter) < 0 : (conflictingConverter instanceof Comparable ? (comparableConflictingConverter = (Comparable)((Object)conflictingConverter)).compareTo(converter) > 0 : false);
            if (overridable) {
                LOGGER.debug("Replacing TypeConverter [{}] for type [{}] with [{}] after comparison.", conflictingConverter, (Object)type, converter);
                this.typeConverters.put(type, converter);
                return converter;
            }
            LOGGER.warn("Ignoring TypeConverter [{}] for type [{}] that conflicts with [{}], since they are not comparable.", converter, (Object)type, conflictingConverter);
            return conflictingConverter;
        }
        this.typeConverters.put(type, converter);
        return converter;
    }

    private static Type getTypeConverterSupportedType(Class<?> clazz) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != TypeConverter.class) continue;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return Void.TYPE;
    }
}

