/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;

public record PluginEntry(String key, String className, String name, String elementType, boolean printable, boolean deferChildren, String namespace) implements Comparable<PluginEntry>
{
    @Override
    public int compareTo(PluginEntry o) {
        int namespaceComparison = this.namespace.compareToIgnoreCase(o.namespace);
        if (namespaceComparison != 0) {
            return namespaceComparison;
        }
        return this.name.compareToIgnoreCase(o.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<PluginEntry> {
        private String key;
        private String className;
        private String name;
        private String elementType = "";
        private boolean printable;
        private boolean deferChildren;
        private String namespace = "";

        public String getKey() {
            String name;
            if (this.key == null && (name = this.name) != null) {
                this.key = name.toLowerCase(Locale.ROOT);
            }
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public String getClassName() {
            return this.className;
        }

        public Builder setClassName(String className) {
            this.className = className;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public String getElementType() {
            if (this.elementType == null) {
                this.elementType = "";
            }
            return this.elementType;
        }

        public Builder setElementType(String elementType) {
            this.elementType = elementType;
            return this;
        }

        public boolean isPrintable() {
            return this.printable;
        }

        public Builder setPrintable(boolean printable) {
            this.printable = printable;
            return this;
        }

        public boolean isDeferChildren() {
            return this.deferChildren;
        }

        public Builder setDeferChildren(boolean deferChildren) {
            this.deferChildren = deferChildren;
            return this;
        }

        public String getNamespace() {
            if (this.namespace == null) {
                this.namespace = "";
            }
            return this.namespace;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public PluginEntry get() {
            String key = Objects.requireNonNull(this.getKey(), () -> "key is null from " + String.valueOf(this));
            String className = Objects.requireNonNull(this.getClassName(), () -> "className is null from " + String.valueOf(this));
            String name = Objects.requireNonNull(this.getName(), () -> "name is null from " + String.valueOf(this));
            String elementType = this.getElementType();
            boolean printable = this.isPrintable();
            boolean deferChildren = this.isDeferChildren();
            String namespace = this.getNamespace();
            return new PluginEntry(key, className, name, elementType, printable, deferChildren, namespace);
        }

        public String toString() {
            return "PluginEntry.Builder{key='" + this.key + "', className='" + this.className + "', name='" + this.name + "', elementType='" + this.elementType + "', printable=" + this.printable + ", deferChildren=" + this.deferChildren + ", namespace='" + this.namespace + "'}";
        }
    }
}

