/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.validation.validators;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.validation.constraints.RequiredProperty;
import org.apache.logging.log4j.status.StatusLogger;

public class RequiredPropertyValidator
implements ConstraintValidator<RequiredProperty> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private RequiredProperty annotation;

    @Override
    public void initialize(RequiredProperty anAnnotation) {
        this.annotation = anAnnotation;
    }

    @Override
    public boolean isValid(String name, Object value) {
        String property = PropertyEnvironment.getGlobal().getStringProperty(this.annotation.name());
        if (property == null) {
            LOGGER.error("{} cannot be used. Required property {} is not defined", (Object)name, (Object)this.annotation.name());
            return false;
        }
        if (this.annotation.value().length() > 0 && !this.annotation.value().equalsIgnoreCase(property)) {
            LOGGER.error("{} cannot be used. Required property {} is not set to {}", (Object)name, (Object)this.annotation.name(), (Object)this.annotation.value());
            return false;
        }
        return true;
    }
}

