/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.internal.util.AnnotatedAnnotation;

public final class AnnotationUtil {
    public static boolean isMetaAnnotationPresent(AnnotatedElement element, Class<? extends Annotation> metaAnnotation) {
        return AnnotationUtil.findAnnotatedAnnotations(element, metaAnnotation).findAny().isPresent();
    }

    public static Annotation getElementAnnotationHavingMetaAnnotation(AnnotatedElement element, Class<? extends Annotation> metaAnnotation) {
        return AnnotationUtil.findAnnotatedAnnotations(element, metaAnnotation).map(AnnotatedAnnotation::annotation).findFirst().orElse(null);
    }

    public static <M extends Annotation> Stream<AnnotatedAnnotation<? extends Annotation, M>> findAnnotatedAnnotations(AnnotatedElement element, Class<M> metaAnnotation) {
        Stream.Builder<AnnotatedAnnotation<Annotation, M>> matched = Stream.builder();
        AnnotationUtil.scanElementForMetaAnnotations(element, metaAnnotation, new HashSet<Class<? extends Annotation>>(), matched);
        return matched.build();
    }

    private static <M extends Annotation> void scanElementForMetaAnnotations(AnnotatedElement element, Class<M> metaAnnotationType, Set<Class<? extends Annotation>> visitedAnnotations, Stream.Builder<AnnotatedAnnotation<? extends Annotation, M>> matched) {
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String packageName = annotationType.getPackageName();
            if (packageName.startsWith("java.lang.") || packageName.startsWith("org.jspecify.annotations.") || !visitedAnnotations.add(annotationType)) continue;
            M metaAnnotation = annotationType.getAnnotation(metaAnnotationType);
            if (metaAnnotation != null) {
                matched.add(new AnnotatedAnnotation<Annotation, M>(annotation, metaAnnotation));
            }
            AnnotationUtil.scanElementForMetaAnnotations(annotationType, metaAnnotationType, visitedAnnotations, matched);
        }
    }

    public static <A extends Annotation> A getLogicalAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return (A)((Annotation)AnnotationUtil.findLogicalAnnotations(element, annotationType).findFirst().orElse(null));
    }

    public static <A extends Annotation> List<A> getLogicalAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotationUtil.findLogicalAnnotations(element, annotationType).collect(Collectors.toList());
    }

    public static <A extends Annotation> Stream<A> findLogicalAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Stream.Builder builder = Stream.builder();
        AnnotationUtil.scanElementAnnotationsForLogicalAnnotation(element, annotationType, new HashSet<Class<? extends Annotation>>(), builder);
        return builder.build();
    }

    private static <A extends Annotation> void scanElementAnnotationsForLogicalAnnotation(AnnotatedElement element, Class<A> logicalAnnotation, Set<Class<? extends Annotation>> visitedAnnotations, Stream.Builder<A> matched) {
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            String packageName = annotationType.getPackageName();
            if (packageName.startsWith("java.lang.") || packageName.startsWith("org.jspecify.annotations.")) continue;
            if (annotationType == logicalAnnotation) {
                matched.add((Annotation)logicalAnnotation.cast(annotation));
                continue;
            }
            if (!visitedAnnotations.add(annotationType)) continue;
            AnnotationUtil.scanElementAnnotationsForLogicalAnnotation(annotationType, logicalAnnotation, visitedAnnotations, matched);
        }
    }

    public static List<Method> getDeclaredMethodsMetaAnnotatedWith(Class<?> type, Class<? extends Annotation> metaAnnotation) {
        return Stream.iterate(type, c -> c != Object.class, Class::getSuperclass).flatMap(c -> Stream.of(c.getDeclaredMethods())).filter(method -> AnnotationUtil.isMetaAnnotationPresent(method, metaAnnotation)).collect(Collectors.toList());
    }

    private AnnotationUtil() {
    }

    public static OptionalInt getOrder(AnnotatedElement element) {
        Ordered ordered = AnnotationUtil.getLogicalAnnotation(element, Ordered.class);
        return ordered == null ? OptionalInt.empty() : OptionalInt.of(ordered.value());
    }
}

