/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.internal.util.BeanUtils;
import org.apache.logging.log4j.plugins.name.AliasesProvider;
import org.apache.logging.log4j.plugins.name.AnnotatedElementAliasesProvider;
import org.apache.logging.log4j.plugins.name.AnnotatedElementNameProvider;
import org.apache.logging.log4j.plugins.name.NameProvider;
import org.apache.logging.log4j.plugins.util.AnnotatedAnnotation;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.ReflectionUtil;

public final class Keys {
    private Keys() {
        throw new IllegalStateException("Utility class");
    }

    public static String getNamespace(AnnotatedElement element) {
        return Optional.ofNullable(AnnotationUtil.getLogicalAnnotation(element, Namespace.class)).map(Namespace::value).orElse("");
    }

    public static boolean hasName(AnnotatedElement element) {
        return AnnotationUtil.isMetaAnnotationPresent(element, NameProvider.class);
    }

    public static String getName(Field field) {
        return Keys.hasName(field) ? Keys.getSpecifiedName(field).orElseGet(field::getName) : "";
    }

    public static String getName(Parameter parameter) {
        return Keys.hasName(parameter) ? Keys.getSpecifiedName(parameter).orElseGet(parameter::getName) : "";
    }

    public static String getName(Method method) {
        return Keys.hasName(method) ? Keys.getSpecifiedName(method).orElseGet(() -> {
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                return BeanUtils.decapitalize(methodName.substring(2));
            }
            if (methodName.startsWith("set") || methodName.startsWith("get")) {
                return BeanUtils.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith("with")) {
                return BeanUtils.decapitalize(methodName.substring(4));
            }
            return methodName;
        }) : "";
    }

    public static String getName(AnnotatedType annotatedType) {
        return Keys.hasName(annotatedType) ? Keys.getSpecifiedName(annotatedType).orElse("") : "";
    }

    public static String getName(Class<?> type) {
        return Keys.hasName(type) ? Keys.getSpecifiedName(type).orElseGet(type::getSimpleName) : "";
    }

    private static Optional<String> getSpecifiedName(AnnotatedElement element) {
        return AnnotationUtil.findAnnotatedAnnotations(element, NameProvider.class).findFirst().flatMap(Keys::getSpecifiedName);
    }

    private static <A extends Annotation> Optional<String> getSpecifiedName(AnnotatedAnnotation<A, NameProvider> annotatedAnnotation) {
        Class providerType = (Class)Cast.cast(annotatedAnnotation.metaAnnotation().value());
        AnnotatedElementNameProvider provider = (AnnotatedElementNameProvider)ReflectionUtil.instantiate((Class)providerType);
        return provider.getSpecifiedName(annotatedAnnotation.annotation());
    }

    public static Collection<String> getAliases(AnnotatedElement element) {
        return AnnotationUtil.findAnnotatedAnnotations(element, AliasesProvider.class).findFirst().map(Keys::getAliases).orElseGet(List::of);
    }

    private static <A extends Annotation> Collection<String> getAliases(AnnotatedAnnotation<A, AliasesProvider> annotatedAnnotation) {
        Class providerType = (Class)Cast.cast(annotatedAnnotation.metaAnnotation().value());
        AnnotatedElementAliasesProvider provider = (AnnotatedElementAliasesProvider)ReflectionUtil.instantiate((Class)providerType);
        return provider.getAliases(annotatedAnnotation.annotation());
    }
}

