/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.model;

import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.model.PluginCache;
import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.plugins.model.PluginService;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Unbox;

@Singleton
public class PluginRegistry {
    private static final String PLUGIN_CACHE_FILE = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Lazy<Namespaces> namespacesLazy = Lazy.lazy(() -> {
        Namespaces namespaces = this.decodeCacheFiles(LoaderUtil.getClassLoader());
        Throwable throwable = null;
        ClassLoader errorClassLoader = null;
        boolean allFail = true;
        for (ClassLoader classLoader : LoaderUtil.getClassLoaders()) {
            try {
                this.loadPlugins(classLoader, namespaces);
                allFail = false;
            }
            catch (Throwable ex) {
                if (throwable != null) continue;
                throwable = ex;
                errorClassLoader = classLoader;
            }
        }
        if (allFail && throwable != null) {
            LOGGER.debug("Unable to retrieve provider from ClassLoader {}", errorClassLoader, throwable);
        }
        return namespaces;
    });

    public void clear() {
        this.namespacesLazy.set(null);
    }

    private void loadPlugins(ClassLoader classLoader, Namespaces namespaces) {
        long startTime = System.nanoTime();
        ServiceLoader<PluginService> serviceLoader = ServiceLoader.load(PluginService.class, classLoader);
        AtomicInteger pluginCount = new AtomicInteger();
        for (PluginService pluginService : serviceLoader) {
            pluginService.getNamespaces().values().forEach(category -> pluginCount.addAndGet(namespaces.merge((PluginNamespace)category)));
        }
        int numPlugins = pluginCount.get();
        LOGGER.debug(() -> {
            long endTime = System.nanoTime();
            DecimalFormat numFormat = new DecimalFormat("#0.000000");
            return "Took " + numFormat.format((double)(endTime - startTime) * 1.0E-9) + " seconds to load " + numPlugins + " plugins from " + classLoader;
        });
    }

    private Namespaces decodeCacheFiles(ClassLoader classLoader) {
        long startTime = System.nanoTime();
        PluginCache cache = new PluginCache();
        try {
            Enumeration<URL> resources = classLoader.getResources(PLUGIN_CACHE_FILE);
            if (resources == null) {
                LOGGER.info("Plugin preloads not available from class loader {}", (Object)classLoader);
            } else {
                cache.loadCacheFiles(resources);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to preload plugins", (Throwable)ioe);
        }
        Namespaces namespaces = new Namespaces();
        AtomicInteger pluginCount = new AtomicInteger();
        cache.getAllNamespaces().forEach((key, outer) -> outer.values().forEach(entry -> {
            PluginType type = new PluginType((PluginEntry)entry, classLoader);
            namespaces.add(type);
            pluginCount.incrementAndGet();
        }));
        int numPlugins = pluginCount.get();
        LOGGER.debug(() -> {
            long endTime = System.nanoTime();
            DecimalFormat numFormat = new DecimalFormat("#0.000000");
            return "Took " + numFormat.format((double)(endTime - startTime) * 1.0E-9) + " seconds to load " + numPlugins + " plugins from " + classLoader;
        });
        return namespaces;
    }

    public PluginNamespace getNamespace(String namespace) {
        PluginNamespace pluginNamespace = new PluginNamespace(namespace);
        Namespaces builtInPlugins = (Namespaces)this.namespacesLazy.value();
        if (builtInPlugins != null) {
            pluginNamespace.mergeAll(builtInPlugins.get(namespace));
        }
        LOGGER.debug("Discovered {} plugins in namespace '{}'", (Object)Unbox.box((int)pluginNamespace.size()), (Object)namespace);
        return pluginNamespace;
    }

    private static final class Namespaces
    implements Iterable<PluginNamespace> {
        private final Map<String, PluginNamespace> namespaces = new LinkedHashMap<String, PluginNamespace>();

        private Namespaces() {
        }

        public boolean isEmpty() {
            return this.namespaces.isEmpty();
        }

        public int merge(PluginNamespace category) {
            PluginNamespace existingCategory = this.getOrCreate(category.getKey());
            int added = 0;
            for (PluginType<?> pluginType : category) {
                if (!existingCategory.add(pluginType)) continue;
                ++added;
            }
            return added;
        }

        public void add(PluginType<?> pluginType) {
            this.getOrCreate(pluginType.getNamespace()).put(pluginType);
        }

        public PluginNamespace get(String category) {
            return this.namespaces.get(category.toLowerCase(Locale.ROOT));
        }

        public PluginNamespace getOrCreate(String category) {
            return this.namespaces.computeIfAbsent(category.toLowerCase(Locale.ROOT), key -> new PluginNamespace((String)key, category));
        }

        @Override
        public Iterator<PluginNamespace> iterator() {
            return this.namespaces.values().iterator();
        }
    }
}

