/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.internal.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.plugins.internal.util.HierarchicalMap;

class HierarchicalCollections {
    HierarchicalCollections() {
    }

    static <K, V> HierarchicalMap<K, V> newRootMap() {
        return new RootMap();
    }

    private static final class HierarchicalIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private final Iterator<E> parent;
        private State state;

        private HierarchicalIterator(Iterator<E> delegate, Iterator<E> parent) {
            this.delegate = delegate;
            this.parent = parent;
            this.state = State.ITERATING_DELEGATE;
        }

        @Override
        public boolean hasNext() {
            switch (this.state) {
                case ITERATING_DELEGATE: {
                    if (this.delegate.hasNext()) {
                        return true;
                    }
                    this.state = State.ITERATING_PARENT;
                }
                case ITERATING_PARENT: {
                    if (this.parent.hasNext()) {
                        return true;
                    }
                    this.state = State.DONE;
                }
            }
            return false;
        }

        @Override
        public E next() {
            switch (this.state) {
                case ITERATING_DELEGATE: {
                    if (this.delegate.hasNext()) {
                        return this.delegate.next();
                    }
                    this.state = State.ITERATING_PARENT;
                }
                case ITERATING_PARENT: {
                    if (this.parent.hasNext()) {
                        return this.parent.next();
                    }
                    this.state = State.DONE;
                }
            }
            throw new NoSuchElementException("Completed iteration");
        }

        @Override
        public void remove() {
            switch (this.state) {
                case ITERATING_DELEGATE: {
                    this.delegate.remove();
                    break;
                }
                case ITERATING_PARENT: {
                    this.parent.remove();
                    break;
                }
                default: {
                    throw new IllegalStateException("Completed iteration");
                }
            }
        }

        private static enum State {
            ITERATING_DELEGATE,
            ITERATING_PARENT,
            DONE;

        }
    }

    private static final class HierarchicalSet<E>
    extends AbstractSet<E> {
        private final Set<E> delegate;
        private final Set<E> parent;

        private HierarchicalSet(Set<E> delegate, Set<E> parent) {
            this.delegate = delegate;
            this.parent = parent;
        }

        @Override
        public Iterator<E> iterator() {
            return new HierarchicalIterator<E>(this.delegate.iterator(), this.parent.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size() + this.parent.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o) || this.parent.contains(o);
        }
    }

    private static final class ChildMap<K, V>
    extends RootMap<K, V> {
        private final Map<K, V> parent;

        private ChildMap(Map<K, V> parent) {
            this.parent = parent;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new HierarchicalSet<Map.Entry<K, V>>(super.entrySet(), this.parent.entrySet());
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key) || this.parent.containsKey(key);
        }

        @Override
        public Set<K> keySet() {
            return new HierarchicalSet(super.keySet(), this.parent.keySet());
        }

        @Override
        public HierarchicalMap<K, V> newChildMap() {
            return new ChildMap<K, V>(this);
        }
    }

    private static class RootMap<K, V>
    extends AbstractMap<K, V>
    implements HierarchicalMap<K, V> {
        private final Map<K, V> map = new ConcurrentHashMap();

        private RootMap() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(key, value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsLocalKey(K key) {
            return this.map.containsKey(key);
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public HierarchicalMap<K, V> newChildMap() {
            return new ChildMap(this);
        }
    }
}

