/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.osgi;

import java.security.Permission;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.model.PluginRegistry;
import org.apache.logging.log4j.plugins.model.PluginService;
import org.apache.logging.log4j.status.StatusLogger;
import org.osgi.annotation.bundle.Header;
import org.osgi.annotation.bundle.Headers;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

@Headers(value={@Header(name="Bundle-Activator", value="${@class}"), @Header(name="Bundle-ActivationPolicy", value="lazy")})
public final class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    public static final String CORE_MODULE_NAME = "org.apache.logging.log4j.core";
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private int state = 1;
    private ServiceReference<PluginRegistry> pluginRegistryServiceReference;
    private PluginRegistry pluginRegistry;

    public void start(BundleContext bundleContext) throws Exception {
        this.state = 8;
        bundleContext.addBundleListener((BundleListener)this);
        this.contextRef.compareAndSet(null, bundleContext);
    }

    private void loadPlugins(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                LOGGER.debug("Bundle {} has no context (state={}), skipping loading plugins", (Object)bundle.getSymbolicName(), (Object)this.toStateString(bundle.getState()));
            } else {
                Collection serviceReferences = bundleContext.getServiceReferences(PluginService.class, null);
                for (ServiceReference serviceReference : serviceReferences) {
                    PluginService pluginService = (PluginService)bundleContext.getService(serviceReference);
                    this.pluginRegistry.loadFromBundle(bundleContext.getBundle().getBundleId(), pluginService.getNamespaces());
                }
            }
        }
        catch (SecurityException e) {
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", (Object)bundle.getSymbolicName(), (Object)e);
        }
        catch (InvalidSyntaxException ex) {
            LOGGER.error("Error accessing Plugins", (Throwable)ex);
        }
        catch (Exception e) {
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", (Object)bundle.getSymbolicName(), (Object)e);
        }
    }

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkPermission(permission);
        }
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toString(state);
    }

    private void scanInstalledBundlesForPlugins(BundleContext context) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            this.scanBundleForPlugins(bundle);
        }
    }

    private void scanBundleForPlugins(Bundle bundle) {
        long bundleId = bundle.getBundleId();
        if (bundle.getState() == 32 && bundleId != 0L) {
            LOGGER.trace("Scanning bundle [{}, id={}] for plugins.", (Object)bundle.getSymbolicName(), (Object)bundleId);
            ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            this.pluginRegistry.loadFromBundle(bundleId, classLoader);
        }
    }

    private void stopBundlePlugins(Bundle bundle) {
        LOGGER.trace("Stopping bundle [{}] plugins.", (Object)bundle.getSymbolicName());
        if (this.pluginRegistry != null) {
            this.pluginRegistry.clearBundlePlugins(bundle.getBundleId());
        }
    }

    public void stop(BundleContext context) throws Exception {
        Bundle[] bundles;
        for (Bundle bundle : bundles = context.getBundles()) {
            this.stopBundlePlugins(bundle);
        }
        this.stopBundlePlugins(context.getBundle());
        this.contextRef.compareAndSet(context, null);
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 128: {
                if (!CORE_MODULE_NAME.equals(bundle.getSymbolicName()) || this.state == 32) break;
                break;
            }
            case 2: {
                if (CORE_MODULE_NAME.equals(bundle.getSymbolicName()) && this.state != 32) {
                    BundleContext bundleContext = this.contextRef.get();
                    this.pluginRegistryServiceReference = bundleContext.getServiceReference(PluginRegistry.class);
                    this.pluginRegistry = (PluginRegistry)bundleContext.getService(this.pluginRegistryServiceReference);
                    this.scanInstalledBundlesForPlugins(bundleContext);
                    this.state = 32;
                    break;
                }
                if (this.state != 32) break;
                this.loadPlugins(bundle);
                this.scanBundleForPlugins(bundle);
                break;
            }
            case 256: {
                if (CORE_MODULE_NAME.equals(bundle.getSymbolicName()) && this.pluginRegistry != null) {
                    this.pluginRegistry = null;
                    this.contextRef.get().ungetService(this.pluginRegistryServiceReference);
                }
                this.stopBundlePlugins(bundle);
                break;
            }
        }
    }
}

