/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.FactoryType;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginException;
import org.apache.logging.log4j.plugins.ScopeType;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.condition.Conditional;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.convert.TypeConverterFactory;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.CircularDependencyException;
import org.apache.logging.log4j.plugins.di.DefaultScope;
import org.apache.logging.log4j.plugins.di.DependencyChain;
import org.apache.logging.log4j.plugins.di.InjectException;
import org.apache.logging.log4j.plugins.di.InjectionPoint;
import org.apache.logging.log4j.plugins.di.Injector;
import org.apache.logging.log4j.plugins.di.InjectorCallback;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.di.ReflectionAccessor;
import org.apache.logging.log4j.plugins.di.Scope;
import org.apache.logging.log4j.plugins.di.SingletonScope;
import org.apache.logging.log4j.plugins.internal.util.BeanUtils;
import org.apache.logging.log4j.plugins.internal.util.HierarchicalMap;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.plugins.model.PluginRegistry;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.validation.Constraint;
import org.apache.logging.log4j.plugins.validation.ConstraintValidationException;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.ServiceRegistry;
import org.apache.logging.log4j.util.StringBuilders;

class DefaultInjector
implements Injector {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Set<Class<?>> COLLECTION_INJECTION_TYPES = Set.of(Collection.class, Iterable.class, List.class, Map.class, Optional.class, Set.class, Stream.class);
    private final HierarchicalMap<Key<?>, Binding<?>> bindings;
    private final HierarchicalMap<Class<? extends Annotation>, Scope> scopes;
    private ReflectionAccessor accessor = object -> object.setAccessible(true);

    DefaultInjector() {
        this.bindings = HierarchicalMap.newRootMap();
        this.bindings.put(KEY, Binding.from(KEY).toInstance(this));
        this.scopes = HierarchicalMap.newRootMap();
        this.scopes.put(Singleton.class, new SingletonScope());
    }

    DefaultInjector(DefaultInjector original) {
        this.bindings = original.bindings.newChildMap();
        this.scopes = original.scopes.newChildMap();
        this.accessor = original.accessor;
    }

    @Override
    public void init() {
        List callbacks = ServiceRegistry.getInstance().getServices(InjectorCallback.class, MethodHandles.lookup(), null);
        callbacks.sort(InjectorCallback.COMPARATOR);
        for (InjectorCallback callback : callbacks) {
            try {
                callback.configure(this);
            }
            catch (Exception e) {
                LOGGER.error("Unable to configure injection callback {}: {}", (Object)callback, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public Injector copy() {
        return new DefaultInjector(this);
    }

    @Override
    public <T> Supplier<T> getFactory(Key<T> key) {
        return this.getFactory(key, Set.of(), null, DependencyChain.empty());
    }

    @Override
    public TypeConverter<?> getTypeConverter(Type type) {
        return this.getInstance(TypeConverterFactory.class).getTypeConverter(type);
    }

    @Override
    public void injectMembers(Object instance) {
        this.injectMembers(Key.forClass(instance.getClass()), null, instance, DependencyChain.empty(), null);
    }

    @Override
    public <T> T configure(Node node) {
        PluginType<?> type = node.getType();
        if (type != null && type.isDeferChildren()) {
            this.inject(node);
        } else {
            node.getChildren().forEach(this::configure);
            if (type == null) {
                if (node.getParent() == null) {
                    LOGGER.error("Unable to locate plugin for node {}", (Object)node.getName());
                }
            } else {
                this.inject(node);
            }
        }
        DefaultInjector.verifyAttributesConsumed(node);
        DefaultInjector.verifyChildrenConsumed(node);
        return node.getObject();
    }

    @Override
    public void registerScope(Class<? extends Annotation> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    @Override
    public Scope getScope(Class<? extends Annotation> scopeType) {
        return (Scope)this.scopes.get(scopeType);
    }

    @Override
    public void registerBundle(Object bundle) {
        if (bundle instanceof Class) {
            this.registerBundleInstance(this.getInstance((Class)bundle));
        } else {
            this.registerBundleInstance(bundle);
        }
    }

    @Override
    public <T> Injector registerBinding(Key<T> key, Supplier<? extends T> factory) {
        this.bindings.put(key, Binding.from(key).to(factory));
        return this;
    }

    @Override
    public <T> Injector registerBindingIfAbsent(Key<T> key, Supplier<? extends T> factory) {
        this.bindings.putIfAbsent(key, Binding.from(key).to(factory));
        return this;
    }

    @Override
    public void removeBinding(Key<?> key) {
        this.bindings.remove(key);
    }

    @Override
    public boolean hasBinding(Key<?> key) {
        return this.bindings.containsKey(key);
    }

    @Override
    public void setReflectionAccessor(ReflectionAccessor accessor) {
        this.accessor = accessor;
    }

    private <T> Supplier<T> getFactory(InjectionPoint<T> point, Node node, DependencyChain chain, StringBuilder debugLog) {
        NodeVisitor visitor;
        AnnotatedElement element = point.getElement();
        Key<? extends NodeVisitor> visitorKey = NodeVisitor.keyFor(element);
        NodeVisitor nodeVisitor = visitor = visitorKey != null ? this.getInstance(visitorKey) : null;
        if (visitor != null) {
            if (element instanceof Field) {
                return () -> Cast.cast((Object)visitor.visitField((Field)element, node, debugLog));
            }
            return () -> Cast.cast((Object)visitor.visitParameter((Parameter)element, node, debugLog));
        }
        Key<T> key = point.getKey();
        Collection<String> aliases = point.getAliases();
        Key suppliedType = key.getSuppliedType();
        return suppliedType != null ? this.getFactory(suppliedType, aliases, node, DependencyChain.empty()) : this.getFactory(key, aliases, node, chain);
    }

    private <T> Supplier<T> getFactory(Key<T> key, Collection<String> aliases, Node node, DependencyChain chain) {
        Supplier<Optional> optionalFactory;
        Key optionalKey;
        Binding existing = (Binding)this.bindings.get(key);
        if (existing != null) {
            return (Supplier)Cast.cast((Object)existing);
        }
        for (String alias : aliases) {
            Key<T> keyAlias = key.withName(alias);
            Binding existingAlias = (Binding)this.bindings.get(keyAlias);
            if (existingAlias == null) continue;
            return (Supplier)Cast.cast((Object)existingAlias);
        }
        Class<T> rawType = key.getRawType();
        Scope scope = this.getScopeForType(rawType);
        if (rawType == PluginNamespace.class && !key.getNamespace().isEmpty()) {
            Key pluginNamespaceKey = (Key)Cast.cast(key);
            Supplier<PluginNamespace> pluginNamespaceFactory = this.createPluginNamespaceFactory(pluginNamespaceKey);
            return (Supplier)Cast.cast(this.merge(pluginNamespaceKey, pluginNamespaceFactory));
        }
        if (COLLECTION_INJECTION_TYPES.contains(rawType) && !key.getNamespace().isEmpty()) {
            if (Stream.class.isAssignableFrom(rawType)) {
                Key streamKey = (Key)Cast.cast(key);
                Supplier<Stream> streamFactory = () -> this.streamPluginInstancesFromNamespace(key.getParameterizedTypeArgument(0));
                return (Supplier)Cast.cast(this.merge(streamKey, streamFactory));
            }
            if (Set.class.isAssignableFrom(rawType)) {
                Key setKey = (Key)Cast.cast(key);
                Supplier<Set> setFactory = () -> this.getPluginSet(key.getParameterizedTypeArgument(0));
                return (Supplier)Cast.cast(this.merge(setKey, setFactory));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                Key mapKey = (Key)Cast.cast(key);
                Supplier<Map> mapFactory = () -> this.getPluginMap(key.getParameterizedTypeArgument(1));
                return (Supplier)Cast.cast(this.merge(mapKey, mapFactory));
            }
            if (Iterable.class.isAssignableFrom(rawType)) {
                Key iterableKey = (Key)Cast.cast(key);
                Supplier<Iterable> iterableFactory = () -> this.getPluginList(key.getParameterizedTypeArgument(0));
                return (Supplier)Cast.cast(this.merge(iterableKey, iterableFactory));
            }
            if (Optional.class.isAssignableFrom(rawType)) {
                optionalKey = (Key)Cast.cast(key);
                optionalFactory = () -> this.getOptionalPlugin(key.getParameterizedTypeArgument(0));
                return (Supplier)Cast.cast(this.merge(optionalKey, optionalFactory));
            }
            throw new InjectException("Cannot inject plugins into " + key);
        }
        if (rawType == Optional.class) {
            optionalKey = (Key)Cast.cast(key);
            optionalFactory = () -> this.getOptionalInstance(key.getParameterizedTypeArgument(0), aliases, node, chain);
            return (Supplier)Cast.cast(this.merge(optionalKey, optionalFactory));
        }
        Supplier<Object> instanceSupplier = () -> {
            StringBuilder debugLog = new StringBuilder();
            Object instance = this.getInjectableInstance(key, node, chain, debugLog);
            this.injectMembers(key, node, instance, chain, debugLog);
            return instance;
        };
        return this.merge(key, scope.get(key, instanceSupplier));
    }

    private <T> Supplier<T> merge(Key<T> key, Supplier<T> factory) {
        Binding binding = this.bindings.merge(key, Binding.from(key).to(factory), (oldValue, value) -> oldValue.getKey().getOrder() <= value.getKey().getOrder() ? oldValue : value);
        return (Supplier)Cast.cast((Object)binding);
    }

    private Supplier<PluginNamespace> createPluginNamespaceFactory(Key<PluginNamespace> key) {
        return () -> ((Lazy)Lazy.lazy(() -> this.getInstance(PluginRegistry.class).getNamespace(key.getNamespace()))).value();
    }

    private <T> Stream<PluginType<T>> streamPluginsFromNamespace(Key<T> itemKey) {
        if (itemKey == null) {
            return Stream.empty();
        }
        PluginNamespace namespace = this.getInstance(PluginRegistry.class).getNamespace(itemKey.getNamespace());
        Type type = itemKey.getType();
        return namespace.stream().filter(pluginType -> TypeUtil.isAssignable(type, pluginType.getPluginClass())).sorted(Comparator.comparing(PluginType::getPluginClass, OrderedComparator.INSTANCE)).map(o -> (PluginType)Cast.cast((Object)o));
    }

    private <T> Stream<T> streamPluginInstancesFromNamespace(Key<T> key) {
        if (key == null) {
            return Stream.empty();
        }
        if (key.getRawType() == Supplier.class) {
            Key itemKey = key.getParameterizedTypeArgument(0);
            Stream<Supplier> factoryStream = this.streamPluginsFromNamespace(itemKey).map(pluginType -> this.getFactory(pluginType.getPluginClass()));
            return (Stream)Cast.cast(factoryStream);
        }
        return this.streamPluginsFromNamespace(key).map(pluginType -> this.getInstance(pluginType.getPluginClass()));
    }

    private <T> Set<T> getPluginSet(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T> Map<String, T> getPluginMap(Key<T> key) {
        if (key.getRawType() == Supplier.class) {
            Key itemKey = key.getParameterizedTypeArgument(0);
            Map map = this.streamPluginsFromNamespace(itemKey).collect(Collectors.toMap(PluginType::getKey, pluginType -> this.getFactory(pluginType.getPluginClass()), (lhs, rhs) -> lhs, LinkedHashMap::new));
            return (Map)Cast.cast((Object)map);
        }
        return this.streamPluginsFromNamespace(key).collect(Collectors.toMap(PluginType::getKey, pluginType -> this.getInstance(pluginType.getPluginClass()), (lhs, rhs) -> lhs, LinkedHashMap::new));
    }

    private <T> List<T> getPluginList(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).collect(Collectors.toList());
    }

    private <T> Optional<T> getOptionalPlugin(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).findFirst();
    }

    private <T> Optional<T> getOptionalInstance(Key<T> key, Collection<String> aliases, Node node, DependencyChain chain) {
        try {
            return Optional.ofNullable(this.getFactory(key, aliases, node, chain).get());
        }
        catch (PluginException e) {
            return Optional.empty();
        }
    }

    private <T> T getInjectableInstance(Key<T> key, Node node, DependencyChain chain, StringBuilder debugLog) {
        Class<T> rawType = key.getRawType();
        this.validate(rawType, key.getName(), rawType);
        Constructor<T> constructor = BeanUtils.getInjectableConstructor(key, chain);
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(constructor);
        Object[] args = this.getArguments(key, node, points, chain, debugLog);
        return this.accessor.newInstance(constructor, args);
    }

    private void validate(AnnotatedElement element, String name, Object value) {
        int errors = 0;
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Constraint constraint = annotationType.getAnnotation(Constraint.class);
            if (constraint == null || !DefaultInjector.isCompatibleValidator(constraint, annotationType)) continue;
            ConstraintValidator<? extends Annotation> validator = this.getInstance(constraint.value());
            DefaultInjector.initializeConstraintValidator(validator, annotation);
            if (validator.isValid(name, value)) continue;
            ++errors;
        }
        if (errors > 0) {
            throw new ConstraintValidationException(element, name, value);
        }
    }

    private void injectMembers(Key<?> key, Node node, Object instance, DependencyChain chain, StringBuilder debugLog) {
        this.injectFields(key.getRawType(), node, instance, debugLog);
        this.injectMethods(key, node, instance, chain, debugLog);
    }

    private void injectFields(Class<?> rawType, Node node, Object instance, StringBuilder debugLog) {
        for (Class<?> clazz = rawType; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!BeanUtils.isInjectable(field)) continue;
                this.injectField(field, node, instance, debugLog);
            }
        }
    }

    private <T> void injectField(Field field, Node node, Object instance, StringBuilder debugLog) {
        Supplier value;
        InjectionPoint point = InjectionPoint.forField(field);
        Supplier factory = this.getFactory(point, node, DependencyChain.empty(), debugLog);
        Key key = point.getKey();
        Supplier supplier = value = key.getRawType() == Supplier.class ? factory : factory.get();
        if (value != null) {
            this.accessor.setFieldValue(field, instance, value);
        }
        if (AnnotationUtil.isMetaAnnotationPresent(field, Constraint.class)) {
            Object fieldValue = this.accessor.getFieldValue(field, instance);
            this.validate(field, key.getName(), fieldValue);
        }
    }

    private void injectMethods(Key<?> key, Node node, Object instance, DependencyChain chain, StringBuilder debugLog) {
        Class<?> rawType = key.getRawType();
        ArrayList<Method> injectMethodsWithNoArgs = new ArrayList<Method>();
        for (Class<?> clazz = rawType; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method2 : clazz.getDeclaredMethods()) {
                if (!BeanUtils.isInjectable(method2)) continue;
                this.accessor.makeAccessible(method2, instance);
                if (method2.getParameterCount() == 0) {
                    injectMethodsWithNoArgs.add(method2);
                    continue;
                }
                List<InjectionPoint<?>> injectionPoints = InjectionPoint.fromExecutable(method2);
                Object[] args = this.getArguments(key, node, injectionPoints, chain, debugLog);
                this.accessor.invokeMethod(method2, instance, args);
            }
        }
        injectMethodsWithNoArgs.forEach(method -> this.accessor.invokeMethod((Method)method, instance, new Object[0]));
    }

    private void inject(Node node) {
        PluginType<?> type = node.getType();
        Class<?> pluginClass = type.getPluginClass();
        List<Node> children = node.getChildren();
        if (Map.class.isAssignableFrom(pluginClass)) {
            LinkedHashMap map = new LinkedHashMap(children.size());
            children.forEach(child -> map.put(child.getName(), child.getObject()));
            node.setObject(map);
            return;
        }
        if (Collection.class.isAssignableFrom(pluginClass)) {
            ArrayList list = new ArrayList(children.size());
            children.forEach(child -> list.add(child.getObject()));
            node.setObject(list);
            return;
        }
        try {
            this.validate(pluginClass, type.getElementType(), pluginClass);
            StringBuilder debugLog = new StringBuilder();
            Object instance = this.getInjectablePluginInstance(node, debugLog);
            if (instance instanceof Supplier) {
                this.injectMembers(Key.forClass(instance.getClass()), node, instance, DependencyChain.empty(), debugLog);
                node.setObject(((Supplier)instance).get());
            } else {
                node.setObject(instance);
            }
            LOGGER.debug("Configured plugin element {}[{}]", (Object)node.getName(), (Object)debugLog);
        }
        catch (Throwable e) {
            LOGGER.error("Could not configure plugin element {}: {}", (Object)node.getName(), (Object)e.toString(), (Object)e);
        }
    }

    private Object getInjectablePluginInstance(Node node, StringBuilder debugLog) {
        PluginType<?> type = node.getType();
        Class<?> rawType = type.getPluginClass();
        Key<?> key = Key.forClass(rawType);
        Conditional conditional = AnnotationUtil.getLogicalAnnotation(rawType, Conditional.class);
        if (conditional != null && !Stream.of(conditional.value()).map(this::getInstance).allMatch(condition -> condition.matches(key, rawType))) {
            return null;
        }
        Executable factory = BeanUtils.getInjectableFactory(rawType);
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(factory);
        if (!factory.canAccess(null)) {
            this.accessor.makeAccessible(factory);
        }
        Object[] args = this.getArguments(key, node, points, DependencyChain.empty(), debugLog);
        if (factory instanceof Method) {
            return this.accessor.invokeMethod((Method)factory, null, args);
        }
        return this.accessor.newInstance((Constructor)factory, args);
    }

    private void registerBundleInstance(Object bundle) {
        Class<?> moduleClass = bundle.getClass();
        ArrayList providerMethods = new ArrayList();
        Stream.iterate(moduleClass, c -> c != Object.class, Class::getSuperclass).flatMap(c -> Stream.of(c.getDeclaredMethods())).filter(method -> AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class)).forEachOrdered(method -> {
            List<Binding<Binding>> bindings;
            if ((method.getDeclaringClass().equals(moduleClass) || providerMethods.stream().noneMatch(m -> m.getName().equals(method.getName()) && Arrays.equals(m.getParameterTypes(), method.getParameterTypes()))) && !(bindings = this.createMethodBindings(bundle, (Method)method)).isEmpty()) {
                providerMethods.add(method);
                bindings.forEach(binding -> this.merge(binding.getKey(), (Supplier)binding));
            }
        });
    }

    private <T> List<Binding<T>> createMethodBindings(Object instance, Method method) {
        this.accessor.makeAccessible(method, instance);
        Key primaryKey = Key.forMethod(method);
        LOGGER.debug("Checking {} on {} for conditions", primaryKey, (Object)method);
        Conditional conditional = AnnotationUtil.getLogicalAnnotation(method, Conditional.class);
        if (conditional != null && !Stream.of(conditional.value()).map(this::getInstance).allMatch(condition -> condition.matches(primaryKey, method))) {
            LOGGER.debug("One or more conditionals failed on {}; skipping", (Object)method);
            return List.of();
        }
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(method);
        Map<Parameter, Supplier<?>> argumentFactories = this.getArgumentFactories(primaryKey, null, points, DependencyChain.of(primaryKey), null);
        Supplier<Object> unscoped = () -> {
            Object[] args = argumentFactories.entrySet().stream().map(e -> {
                Parameter parameter = (Parameter)e.getKey();
                String name = Keys.getName(parameter);
                Object value = ((Supplier)e.getValue()).get();
                this.validate(parameter, name, value);
                return value;
            }).toArray();
            return Cast.cast((Object)this.accessor.invokeMethod(method, instance, args));
        };
        Supplier<Object> factory = this.getScopeForMethod(method).get(primaryKey, unscoped);
        Collection<String> aliases = Keys.getAliases(method);
        ArrayList<Binding<T>> bindings = new ArrayList<Binding<T>>(1 + aliases.size());
        bindings.add(Binding.from(primaryKey).to(factory));
        for (String alias : aliases) {
            bindings.add(Binding.from(primaryKey.withName(alias)).to(factory));
        }
        return bindings;
    }

    private Object[] getArguments(Key<?> key, Node node, List<InjectionPoint<?>> points, DependencyChain chain, StringBuilder debugLog) {
        return this.getArgumentFactories(key, node, points, chain, debugLog).entrySet().stream().map(e -> {
            Parameter parameter = (Parameter)e.getKey();
            String name = Keys.getName(parameter);
            Object value = ((Supplier)e.getValue()).get();
            this.validate(parameter, name, value);
            return value;
        }).toArray();
    }

    private Map<Parameter, Supplier<?>> getArgumentFactories(Key<?> key, Node node, List<InjectionPoint<?>> points, DependencyChain chain, StringBuilder debugLog) {
        LinkedHashMap argFactories = new LinkedHashMap();
        for (InjectionPoint<?> point : points) {
            Key<?> parameterKey = point.getKey();
            Parameter parameter = (Parameter)point.getElement();
            if (parameterKey.getRawType().equals(Supplier.class)) {
                argFactories.put(parameter, () -> this.getFactory(point, node, chain, debugLog));
                continue;
            }
            DependencyChain newChain = chain.withDependency(key);
            if (newChain.hasDependency(parameterKey)) {
                throw new CircularDependencyException(parameterKey, newChain);
            }
            argFactories.put(parameter, () -> this.getFactory(point, node, newChain, debugLog).get());
        }
        return argFactories;
    }

    private Scope getScopeForMethod(Method method) {
        Annotation methodScope = AnnotationUtil.getMetaAnnotation(method, ScopeType.class);
        return methodScope != null ? this.getScope(methodScope.annotationType()) : this.getScopeForType(method.getReturnType());
    }

    private Scope getScopeForType(Class<?> type) {
        Annotation scope = AnnotationUtil.getMetaAnnotation(type, ScopeType.class);
        return scope != null ? this.getScope(scope.annotationType()) : DefaultScope.INSTANCE;
    }

    private static boolean isCompatibleValidator(Constraint constraint, Class<? extends Annotation> annotationType) {
        for (Type type : constraint.value().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != ConstraintValidator.class || parameterizedType.getActualTypeArguments()[0] != annotationType) continue;
            return true;
        }
        return false;
    }

    private static void initializeConstraintValidator(ConstraintValidator<? extends Annotation> validator, Annotation annotation) {
        validator.initialize(annotation);
    }

    private static void verifyAttributesConsumed(Node node) {
        Map<String, String> attrs = node.getAttributes();
        if (!attrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : attrs.keySet()) {
                if (sb.length() == 0) {
                    sb.append(node.getName());
                    sb.append(" contains ");
                    if (attrs.size() == 1) {
                        sb.append("an invalid element or attribute ");
                    } else {
                        sb.append("invalid attributes ");
                    }
                } else {
                    sb.append(", ");
                }
                StringBuilders.appendDqValue((StringBuilder)sb, (Object)key);
            }
            LOGGER.error(sb.toString());
        }
    }

    private static void verifyChildrenConsumed(Node node) {
        PluginType<?> type = node.getType();
        if (type != null && !type.isDeferChildren() && node.hasChildren()) {
            for (Node child : node.getChildren()) {
                String nodeType = node.getType().getElementType();
                String start = nodeType.equalsIgnoreCase(node.getName()) ? node.getName() : nodeType + " " + node.getName();
                LOGGER.error("{} has no field or parameter that matches element {}", (Object)start, (Object)child.getName());
            }
        }
    }
}

