/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.validation.validators;

import java.lang.reflect.Type;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.di.Injector;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Cast;

public class ValidPortValidator
implements ConstraintValidator<ValidPort> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final TypeConverter<Integer> converter;
    private ValidPort annotation;

    @Inject
    public ValidPortValidator(Injector injector) {
        this.converter = (TypeConverter)Cast.cast(injector.getTypeConverter((Type)((Object)Integer.class)));
    }

    @Override
    public void initialize(ValidPort annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(String name, Object value) {
        if (value instanceof CharSequence) {
            return this.isValid(name, this.converter.convert(value.toString(), -1));
        }
        if (!(value instanceof Integer)) {
            LOGGER.error(this.annotation.message());
            return false;
        }
        int port = (Integer)value;
        if (port < 0 || port > 65535) {
            LOGGER.error(this.annotation.message());
            return false;
        }
        return true;
    }
}

