/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.processor.PluginEntry;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.LazyValue;

public class PluginType<T> {
    private final PluginEntry pluginEntry;
    private final Supplier<Class<T>> pluginClass;
    private final Supplier<Set<Class<?>>> implementedInterfaces;

    public PluginType(PluginEntry pluginEntry, Class<T> pluginClass) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = () -> pluginClass;
        Set<Class<?>> interfaces = Set.of(pluginClass.getInterfaces());
        this.implementedInterfaces = () -> interfaces;
    }

    public PluginType(PluginEntry pluginEntry, ClassLoader classLoader) {
        LazyValue classProvider;
        this.pluginEntry = pluginEntry;
        this.pluginClass = classProvider = LazyValue.from(() -> {
            try {
                return (Class)TypeUtil.cast(classLoader.loadClass(pluginEntry.getClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class named " + pluginEntry.getClassName() + " located for element " + pluginEntry.getName(), e);
            }
        });
        Class<?>[] interfaces = pluginEntry.getInterfaces();
        if (interfaces != null) {
            Set<Class<?>> implementedInterfaces = Set.of(interfaces);
            this.implementedInterfaces = () -> implementedInterfaces;
        } else {
            this.implementedInterfaces = classProvider.map(clazz -> Set.of(clazz.getInterfaces()));
        }
    }

    public PluginEntry getPluginEntry() {
        return this.pluginEntry;
    }

    public Class<T> getPluginClass() {
        return this.pluginClass.get();
    }

    public Set<Class<?>> getImplementedInterfaces() {
        return this.implementedInterfaces.get();
    }

    public String getElementType() {
        return this.pluginEntry.getElementType();
    }

    public String getKey() {
        return this.pluginEntry.getKey();
    }

    public boolean isObjectPrintable() {
        return this.pluginEntry.isPrintable();
    }

    public boolean isDeferChildren() {
        return this.pluginEntry.isDeferChildren();
    }

    public String getNamespace() {
        return this.pluginEntry.getNamespace();
    }

    public String getName() {
        return this.pluginEntry.getName();
    }

    public String toString() {
        return "PluginType [pluginClass=" + this.pluginClass.get() + ", key=" + this.pluginEntry.getKey() + ", elementType=" + this.pluginEntry.getElementType() + ", isObjectPrintable=" + this.pluginEntry.isPrintable() + ", isDeferChildren==" + this.pluginEntry.isDeferChildren() + ", namespace=" + this.pluginEntry.getNamespace() + "]";
    }
}

