/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.FactoryType;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.PluginException;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.ScopeType;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.condition.Conditional;
import org.apache.logging.log4j.plugins.convert.TypeConverter;
import org.apache.logging.log4j.plugins.di.Binding;
import org.apache.logging.log4j.plugins.di.BindingMap;
import org.apache.logging.log4j.plugins.di.InjectException;
import org.apache.logging.log4j.plugins.di.InjectionPoint;
import org.apache.logging.log4j.plugins.di.Injector;
import org.apache.logging.log4j.plugins.di.InjectorCallback;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.di.ReflectionAccessor;
import org.apache.logging.log4j.plugins.di.Scope;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.plugins.util.PluginNamespace;
import org.apache.logging.log4j.plugins.util.PluginRegistry;
import org.apache.logging.log4j.plugins.util.PluginType;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.plugins.validation.Constraint;
import org.apache.logging.log4j.plugins.validation.ConstraintValidationException;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.visit.NodeVisitor;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.LazyValue;
import org.apache.logging.log4j.util.ServiceRegistry;
import org.apache.logging.log4j.util.StringBuilders;

class DefaultInjector
implements Injector {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Set<Class<?>> COLLECTION_INJECTION_TYPES = Set.of(Collection.class, Iterable.class, List.class, Map.class, Optional.class, Set.class, Stream.class);
    private final BindingMap bindingMap;
    private final Map<Class<? extends Annotation>, Scope> scopes = new ConcurrentHashMap<Class<? extends Annotation>, Scope>();
    private final Map<Type, TypeConverter<?>> typeConverters = new ConcurrentHashMap();
    private ReflectionAccessor accessor = object -> object.setAccessible(true);

    DefaultInjector() {
        this.bindingMap = new BindingMap();
        this.bindingMap.put(KEY, () -> this);
        this.scopes.put(Singleton.class, new SingletonScope());
    }

    DefaultInjector(DefaultInjector original) {
        this.bindingMap = new BindingMap(original.bindingMap);
        this.scopes.putAll(original.scopes);
        this.typeConverters.putAll(original.typeConverters);
        this.accessor = original.accessor;
    }

    @Override
    public void init() {
        List callbacks = ServiceRegistry.getInstance().getServices(InjectorCallback.class, MethodHandles.lookup(), null);
        callbacks.sort(InjectorCallback.COMPARATOR);
        for (InjectorCallback callback : callbacks) {
            try {
                callback.configure(this);
            }
            catch (Exception e) {
                LOGGER.error("Unable to configure injection callback {}: {}", (Object)callback, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public Injector copy() {
        return new DefaultInjector(this);
    }

    @Override
    public <T> Supplier<T> getFactory(Key<T> key) {
        return this.getFactory(key, Set.of(), null, Set.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeConverter<?> getTypeConverter(Type type) {
        Class clazz;
        TypeConverter<?> primary;
        if (this.typeConverters.isEmpty()) {
            Map<Type, TypeConverter<?>> map = this.typeConverters;
            synchronized (map) {
                if (this.typeConverters.isEmpty()) {
                    LOGGER.trace("Initializing type converters");
                    this.initializeTypeConverters();
                }
            }
        }
        if ((primary = this.typeConverters.get(type)) != null) {
            return primary;
        }
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            return this.registerTypeConverter(type, s -> EnglishEnums.valueOf(clazz.asSubclass(Enum.class), (String)s));
        }
        for (Map.Entry<Type, TypeConverter<?>> entry : this.typeConverters.entrySet()) {
            Type key = entry.getKey();
            if (!TypeUtil.isAssignable(type, key)) continue;
            LOGGER.debug("Found compatible TypeConverter<{}> for type [{}].", (Object)key, (Object)type);
            TypeConverter<?> value = entry.getValue();
            return this.registerTypeConverter(type, value);
        }
        throw new UnknownFormatConversionException(type.toString());
    }

    @Override
    public void injectMembers(Object instance) {
        this.injectMembers(Key.forClass(instance.getClass()), null, instance, Set.of(), null);
    }

    @Override
    public <T> T configure(Node node) {
        PluginType<?> type = node.getType();
        if (type != null && type.isDeferChildren()) {
            this.inject(node);
        } else {
            node.getChildren().forEach(this::configure);
            if (type == null) {
                if (node.getParent() == null) {
                    LOGGER.error("Unable to locate plugin for node {}", (Object)node.getName());
                }
            } else {
                this.inject(node);
            }
        }
        DefaultInjector.verifyAttributesConsumed(node);
        DefaultInjector.verifyChildrenConsumed(node);
        return node.getObject();
    }

    @Override
    public void registerScope(Class<? extends Annotation> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    @Override
    public Scope getScope(Class<? extends Annotation> scopeType) {
        return this.scopes.get(scopeType);
    }

    @Override
    public void registerBundle(Object bundle) {
        if (bundle instanceof Class) {
            this.registerBundleInstance(this.getInstance((Class)bundle));
        } else {
            this.registerBundleInstance(bundle);
        }
    }

    @Override
    public <T> Injector registerBinding(Key<T> key, Supplier<? extends T> factory) {
        this.bindingMap.put(key, factory::get);
        return this;
    }

    @Override
    public <T> Injector registerBindingIfAbsent(Key<T> key, Supplier<? extends T> factory) {
        this.bindingMap.bindIfAbsent(key, factory::get);
        return this;
    }

    @Override
    public void removeBinding(Key<?> key) {
        this.bindingMap.remove(key);
    }

    @Override
    public boolean hasBinding(Key<?> key) {
        return this.bindingMap.get(key) != null;
    }

    @Override
    public void setReflectionAccessor(ReflectionAccessor accessor) {
        this.accessor = accessor;
    }

    private <T> Supplier<T> getFactory(InjectionPoint<T> point, Node node, Set<Key<?>> chain, StringBuilder debugLog) {
        NodeVisitor visitor;
        AnnotatedElement element = point.getElement();
        Key<? extends NodeVisitor> visitorKey = NodeVisitor.keyFor(element);
        NodeVisitor nodeVisitor = visitor = visitorKey != null ? this.getInstance(visitorKey) : null;
        if (visitor != null) {
            if (element instanceof Field) {
                return () -> TypeUtil.cast(visitor.visitField((Field)element, node, debugLog));
            }
            return () -> TypeUtil.cast(visitor.visitParameter((Parameter)element, node, debugLog));
        }
        Key<T> key = point.getKey();
        Collection<String> aliases = point.getAliases();
        Key suppliedType = key.getSuppliedType();
        return suppliedType != null ? this.getFactory(suppliedType, aliases, node, Set.of()) : this.getFactory(key, aliases, node, chain);
    }

    private <T> Supplier<T> getFactory(Key<T> key, Collection<String> aliases, Node node, Set<Key<?>> chain) {
        Binding<T> existing = this.bindingMap.get(key, aliases);
        if (existing != null) {
            return existing.getSupplier();
        }
        Class<T> rawType = key.getRawType();
        Scope scope = this.getScopeForType(rawType);
        if (rawType == PluginNamespace.class && !key.getNamespace().isEmpty()) {
            Key pluginNamespaceKey = (Key)TypeUtil.cast(key);
            Supplier<PluginNamespace> pluginNamespaceFactory = this.createPluginNamespaceFactory(pluginNamespaceKey);
            return (Supplier)TypeUtil.cast(this.bindingMap.merge(pluginNamespaceKey, pluginNamespaceFactory));
        }
        if (COLLECTION_INJECTION_TYPES.contains(rawType) && !key.getNamespace().isEmpty()) {
            if (Stream.class.isAssignableFrom(rawType)) {
                Key streamKey = (Key)TypeUtil.cast(key);
                Supplier<Stream> streamFactory = () -> this.streamPluginInstancesFromNamespace(key.getParameterizedTypeArgument(0));
                return (Supplier)TypeUtil.cast(this.bindingMap.merge(streamKey, streamFactory));
            }
            if (Set.class.isAssignableFrom(rawType)) {
                Key setKey = (Key)TypeUtil.cast(key);
                Supplier<Set> setFactory = () -> this.getPluginSet(key.getParameterizedTypeArgument(0));
                return (Supplier)TypeUtil.cast(this.bindingMap.merge(setKey, setFactory));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                Key mapKey = (Key)TypeUtil.cast(key);
                Supplier<Map> mapFactory = () -> this.getPluginMap(key.getParameterizedTypeArgument(1));
                return (Supplier)TypeUtil.cast(this.bindingMap.merge(mapKey, mapFactory));
            }
            if (Iterable.class.isAssignableFrom(rawType)) {
                Key iterableKey = (Key)TypeUtil.cast(key);
                Supplier<Iterable> iterableFactory = () -> this.getPluginList(key.getParameterizedTypeArgument(0));
                return (Supplier)TypeUtil.cast(this.bindingMap.merge(iterableKey, iterableFactory));
            }
            if (Optional.class.isAssignableFrom(rawType)) {
                Key optionalKey = (Key)TypeUtil.cast(key);
                Supplier<Optional> optionalFactory = () -> this.getOptionalPlugin(key.getParameterizedTypeArgument(0));
                return (Supplier)TypeUtil.cast(this.bindingMap.merge(optionalKey, optionalFactory));
            }
            throw new InjectException("Cannot inject plugins into " + key);
        }
        if (rawType == Optional.class) {
            Key optionalKey = (Key)TypeUtil.cast(key);
            Supplier<Optional> optionalFactory = () -> this.getOptionalInstance(key.getParameterizedTypeArgument(0), aliases, node, chain);
            return (Supplier)TypeUtil.cast(this.bindingMap.merge(optionalKey, optionalFactory));
        }
        Supplier<Object> instanceSupplier = () -> {
            StringBuilder debugLog = new StringBuilder();
            Object instance = TypeUtil.cast(this.getInjectableInstance(key, node, chain, debugLog));
            this.injectMembers(key, node, instance, chain, debugLog);
            return instance;
        };
        return this.bindingMap.merge(key, scope.get(key, instanceSupplier));
    }

    private Supplier<PluginNamespace> createPluginNamespaceFactory(Key<PluginNamespace> key) {
        return LazyValue.from(() -> this.getInstance(PluginRegistry.class).getNamespace(key.getNamespace(), this.getPluginPackages()));
    }

    private List<String> getPluginPackages() {
        Binding<List<String>> pluginPackagesBinding = this.bindingMap.get(Keys.PLUGIN_PACKAGES_KEY, List.of());
        return pluginPackagesBinding != null ? pluginPackagesBinding.getSupplier().get() : List.of();
    }

    private <T> Stream<PluginType<T>> streamPluginsFromNamespace(Key<T> itemKey) {
        if (itemKey == null) {
            return Stream.empty();
        }
        PluginNamespace namespace = this.getInstance(PluginRegistry.class).getNamespace(itemKey.getNamespace(), this.getPluginPackages());
        Type type = itemKey.getType();
        Class rawType = itemKey.getRawType();
        return namespace.stream().filter(pluginType -> rawType.isInterface() && pluginType.getImplementedInterfaces().contains(rawType) || TypeUtil.isAssignable(type, pluginType.getPluginClass())).sorted(Comparator.comparing(PluginType::getPluginClass, OrderedComparator.INSTANCE)).map(TypeUtil::cast);
    }

    private <T> Stream<T> streamPluginInstancesFromNamespace(Key<T> key) {
        if (key == null) {
            return Stream.empty();
        }
        if (key.getRawType() == Supplier.class) {
            Key itemKey = key.getParameterizedTypeArgument(0);
            Stream<Supplier> factoryStream = this.streamPluginsFromNamespace(itemKey).map(pluginType -> this.getFactory(pluginType.getPluginClass()));
            return (Stream)TypeUtil.cast(factoryStream);
        }
        return this.streamPluginsFromNamespace(key).map(pluginType -> this.getInstance(pluginType.getPluginClass()));
    }

    private <T> Set<T> getPluginSet(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private <T> Map<String, T> getPluginMap(Key<T> key) {
        if (key.getRawType() == Supplier.class) {
            Key itemKey = key.getParameterizedTypeArgument(0);
            Map map = this.streamPluginsFromNamespace(itemKey).collect(Collectors.toMap(PluginType::getKey, pluginType -> this.getFactory(pluginType.getPluginClass()), (lhs, rhs) -> lhs, LinkedHashMap::new));
            return (Map)TypeUtil.cast(map);
        }
        return this.streamPluginsFromNamespace(key).collect(Collectors.toMap(PluginType::getKey, pluginType -> this.getInstance(pluginType.getPluginClass()), (lhs, rhs) -> lhs, LinkedHashMap::new));
    }

    private <T> List<T> getPluginList(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).collect(Collectors.toList());
    }

    private <T> Optional<T> getOptionalPlugin(Key<T> key) {
        return this.streamPluginInstancesFromNamespace(key).findFirst();
    }

    private <T> Optional<T> getOptionalInstance(Key<T> key, Collection<String> aliases, Node node, Set<Key<?>> chain) {
        try {
            return Optional.ofNullable(this.getFactory(key, aliases, node, chain).get());
        }
        catch (PluginException e) {
            return Optional.empty();
        }
    }

    private Object getInjectableInstance(Key<?> key, Node node, Set<Key<?>> chain, StringBuilder debugLog) {
        Class<?> rawType = key.getRawType();
        this.validate(rawType, key.getName(), rawType);
        Constructor<?> constructor = DefaultInjector.getInjectableConstructor(key, chain);
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(constructor);
        Object[] args = this.getArguments(key, node, points, chain, debugLog);
        return this.accessor.newInstance(constructor, args);
    }

    private void validate(AnnotatedElement element, String name, Object value) {
        int errors = 0;
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Constraint constraint = annotationType.getAnnotation(Constraint.class);
            if (constraint == null || !DefaultInjector.isCompatibleValidator(constraint, annotationType)) continue;
            ConstraintValidator<? extends Annotation> validator = this.getInstance(constraint.value());
            DefaultInjector.initializeConstraintValidator(validator, annotation);
            if (validator.isValid(name, value)) continue;
            ++errors;
        }
        if (errors > 0) {
            throw new ConstraintValidationException(element, name, value);
        }
    }

    private void initializeTypeConverters() {
        List<TypeConverter> converters = this.getPluginList(new Key<TypeConverter<?>>(){});
        converters.forEach(converter -> this.registerTypeConverter(DefaultInjector.getTypeConverterSupportedType(converter.getClass()), (TypeConverter<?>)converter));
        this.registerTypeConverter((Type)((Object)Boolean.class), Boolean::valueOf);
        this.registerTypeAlias((Type)((Object)Boolean.class), Boolean.TYPE);
        this.registerTypeConverter((Type)((Object)Byte.class), Byte::valueOf);
        this.registerTypeAlias((Type)((Object)Byte.class), Byte.TYPE);
        this.registerTypeConverter((Type)((Object)Character.class), s -> {
            if (s.length() != 1) {
                throw new IllegalArgumentException("Character string must be of length 1: " + s);
            }
            return Character.valueOf(s.toCharArray()[0]);
        });
        this.registerTypeAlias((Type)((Object)Character.class), Character.TYPE);
        this.registerTypeConverter((Type)((Object)Double.class), Double::valueOf);
        this.registerTypeAlias((Type)((Object)Double.class), Double.TYPE);
        this.registerTypeConverter((Type)((Object)Float.class), Float::valueOf);
        this.registerTypeAlias((Type)((Object)Float.class), Float.TYPE);
        this.registerTypeConverter((Type)((Object)Integer.class), Integer::valueOf);
        this.registerTypeAlias((Type)((Object)Integer.class), Integer.TYPE);
        this.registerTypeConverter((Type)((Object)Long.class), Long::valueOf);
        this.registerTypeAlias((Type)((Object)Long.class), Long.TYPE);
        this.registerTypeConverter((Type)((Object)Short.class), Short::valueOf);
        this.registerTypeAlias((Type)((Object)Short.class), Short.TYPE);
        this.registerTypeConverter((Type)((Object)String.class), s -> s);
    }

    private TypeConverter<?> registerTypeConverter(Type type, TypeConverter<?> converter) {
        TypeConverter<?> conflictingConverter = this.typeConverters.get(type);
        if (conflictingConverter != null) {
            Comparable comparableConflictingConverter;
            Comparable comparableConverter;
            boolean overridable = converter instanceof Comparable ? (comparableConverter = (Comparable)((Object)converter)).compareTo(conflictingConverter) < 0 : (conflictingConverter instanceof Comparable ? (comparableConflictingConverter = (Comparable)((Object)conflictingConverter)).compareTo(converter) > 0 : false);
            if (overridable) {
                LOGGER.debug("Replacing TypeConverter [{}] for type [{}] with [{}] after comparison.", conflictingConverter, (Object)type, converter);
                this.typeConverters.put(type, converter);
                return converter;
            }
            LOGGER.warn("Ignoring TypeConverter [{}] for type [{}] that conflicts with [{}], since they are not comparable.", converter, (Object)type, conflictingConverter);
            return conflictingConverter;
        }
        this.typeConverters.put(type, converter);
        return converter;
    }

    private void registerTypeAlias(Type knownType, Type aliasType) {
        TypeConverter<?> converter = this.typeConverters.get(knownType);
        if (converter != null) {
            this.typeConverters.put(aliasType, converter);
        } else {
            LOGGER.error("Cannot locate type converter for {}", (Object)knownType);
        }
    }

    private void injectMembers(Key<?> key, Node node, Object instance, Set<Key<?>> chain, StringBuilder debugLog) {
        this.injectFields(key.getRawType(), node, instance, debugLog);
        this.injectMethods(key, node, instance, chain, debugLog);
    }

    private void injectFields(Class<?> rawType, Node node, Object instance, StringBuilder debugLog) {
        for (Class<?> clazz = rawType; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!DefaultInjector.isInjectable(field)) continue;
                this.injectField(field, node, instance, debugLog);
            }
        }
    }

    private <T> void injectField(Field field, Node node, Object instance, StringBuilder debugLog) {
        Supplier value;
        InjectionPoint point = InjectionPoint.forField(field);
        Supplier factory = this.getFactory(point, node, Set.of(), debugLog);
        Key key = point.getKey();
        Supplier supplier = value = key.getRawType() == Supplier.class ? factory : factory.get();
        if (value != null) {
            this.accessor.setFieldValue(field, instance, value);
        }
        if (AnnotationUtil.isMetaAnnotationPresent(field, Constraint.class)) {
            Object fieldValue = this.accessor.getFieldValue(field, instance);
            this.validate(field, key.getName(), fieldValue);
        }
    }

    private void injectMethods(Key<?> key, Node node, Object instance, Set<Key<?>> chain, StringBuilder debugLog) {
        Class<?> rawType = key.getRawType();
        ArrayList<Method> injectMethodsWithNoArgs = new ArrayList<Method>();
        for (Class<?> clazz = rawType; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method2 : clazz.getDeclaredMethods()) {
                if (!DefaultInjector.isInjectable(method2)) continue;
                this.accessor.makeAccessible(method2, instance);
                if (method2.getParameterCount() == 0) {
                    injectMethodsWithNoArgs.add(method2);
                    continue;
                }
                List<InjectionPoint<?>> injectionPoints = InjectionPoint.fromExecutable(method2);
                Object[] args = this.getArguments(key, node, injectionPoints, chain, debugLog);
                this.accessor.invokeMethod(method2, instance, args);
            }
        }
        injectMethodsWithNoArgs.forEach(method -> this.accessor.invokeMethod((Method)method, instance, new Object[0]));
    }

    private void inject(Node node) {
        PluginType<?> type = node.getType();
        Class<?> pluginClass = type.getPluginClass();
        List<Node> children = node.getChildren();
        if (Map.class.isAssignableFrom(pluginClass)) {
            LinkedHashMap map = new LinkedHashMap(children.size());
            children.forEach(child -> map.put(child.getName(), child.getObject()));
            node.setObject(map);
            return;
        }
        if (Collection.class.isAssignableFrom(pluginClass)) {
            ArrayList list = new ArrayList(children.size());
            children.forEach(child -> list.add(child.getObject()));
            node.setObject(list);
            return;
        }
        try {
            this.validate(pluginClass, type.getElementType(), pluginClass);
            StringBuilder debugLog = new StringBuilder();
            Object instance = this.getInjectablePluginInstance(node, debugLog);
            if (instance instanceof Supplier) {
                this.injectMembers(Key.forClass(instance.getClass()), node, instance, Set.of(), debugLog);
                node.setObject(((Supplier)instance).get());
            } else {
                node.setObject(instance);
            }
            LOGGER.debug("Configured plugin element {}[{}]", (Object)node.getName(), (Object)debugLog);
        }
        catch (Throwable e) {
            LOGGER.error("Could not configure plugin element {}: {}", (Object)node.getName(), (Object)e.toString(), (Object)e);
        }
    }

    private Object getInjectablePluginInstance(Node node, StringBuilder debugLog) {
        PluginType<?> type = node.getType();
        Class<?> rawType = type.getPluginClass();
        Key<?> key = Key.forClass(rawType);
        Conditional conditional = AnnotationUtil.getLogicalAnnotation(rawType, Conditional.class);
        if (conditional != null && !Stream.of(conditional.value()).map(this::getInstance).allMatch(condition -> condition.matches(key, rawType))) {
            return null;
        }
        Executable factory = Stream.of(rawType.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers()) && AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class)).min(Comparator.comparingInt(Method::getParameterCount).thenComparing(Method::getReturnType, (c1, c2) -> {
            if (c1.equals(c2)) {
                return 0;
            }
            if (Supplier.class.isAssignableFrom((Class<?>)c1)) {
                return -1;
            }
            if (Supplier.class.isAssignableFrom((Class<?>)c2)) {
                return 1;
            }
            return c1.getName().compareTo(c2.getName());
        })).map(Executable.class::cast).orElseGet(() -> DefaultInjector.getInjectableConstructor(key, Set.of()));
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(factory);
        if (!factory.canAccess(null)) {
            this.accessor.makeAccessible(factory);
        }
        Object[] args = this.getArguments(key, node, points, Set.of(), debugLog);
        if (factory instanceof Method) {
            return this.accessor.invokeMethod((Method)factory, null, args);
        }
        return this.accessor.newInstance((Constructor)factory, args);
    }

    private void registerBundleInstance(Object bundle) {
        Class<?> moduleClass = bundle.getClass();
        ArrayList providerMethods = new ArrayList();
        Stream.iterate(moduleClass, c -> c != Object.class, Class::getSuperclass).flatMap(c -> Stream.of(c.getDeclaredMethods())).filter(method -> AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class)).forEachOrdered(method -> {
            List<Binding<Binding>> bindings;
            if ((method.getDeclaringClass().equals(moduleClass) || providerMethods.stream().noneMatch(m -> m.getName().equals(method.getName()) && Arrays.equals(m.getParameterTypes(), method.getParameterTypes()))) && !(bindings = this.createMethodBindings(bundle, (Method)method)).isEmpty()) {
                providerMethods.add(method);
                bindings.forEach(binding -> this.bindingMap.merge(binding.getKey(), binding.getSupplier()));
            }
        });
    }

    private <T> List<Binding<T>> createMethodBindings(Object instance, Method method) {
        this.accessor.makeAccessible(method, instance);
        Key primaryKey = Key.forMethod(method);
        LOGGER.debug("Checking {} on {} for conditions", primaryKey, (Object)method);
        Conditional conditional = AnnotationUtil.getLogicalAnnotation(method, Conditional.class);
        if (conditional != null && !Stream.of(conditional.value()).map(this::getInstance).allMatch(condition -> condition.matches(primaryKey, method))) {
            LOGGER.debug("One or more conditionals failed on {}; skipping", (Object)method);
            return List.of();
        }
        List<InjectionPoint<?>> points = InjectionPoint.fromExecutable(method);
        Map<Parameter, Supplier<?>> argumentFactories = this.getArgumentFactories(primaryKey, null, points, Set.of(primaryKey), null);
        Supplier<Object> unscoped = () -> {
            Object[] args = argumentFactories.entrySet().stream().map(e -> {
                Parameter parameter = (Parameter)e.getKey();
                String name = Keys.getName(parameter);
                Object value = ((Supplier)e.getValue()).get();
                this.validate(parameter, name, value);
                return value;
            }).toArray();
            return TypeUtil.cast(this.accessor.invokeMethod(method, instance, args));
        };
        Supplier<Object> factory = this.getScopeForMethod(method).get(primaryKey, unscoped);
        Collection<String> aliases = Keys.getAliases(method);
        ArrayList<Binding<T>> bindings = new ArrayList<Binding<T>>(1 + aliases.size());
        bindings.add(Binding.bind(primaryKey, factory));
        for (String alias : aliases) {
            bindings.add(Binding.bind(primaryKey.withName(alias), factory));
        }
        return bindings;
    }

    private Object[] getArguments(Key<?> key, Node node, List<InjectionPoint<?>> points, Set<Key<?>> chain, StringBuilder debugLog) {
        return this.getArgumentFactories(key, node, points, chain, debugLog).entrySet().stream().map(e -> {
            Parameter parameter = (Parameter)e.getKey();
            String name = Keys.getName(parameter);
            Object value = ((Supplier)e.getValue()).get();
            this.validate(parameter, name, value);
            return value;
        }).toArray();
    }

    private Map<Parameter, Supplier<?>> getArgumentFactories(Key<?> key, Node node, List<InjectionPoint<?>> points, Set<Key<?>> chain, StringBuilder debugLog) {
        LinkedHashMap argFactories = new LinkedHashMap();
        for (InjectionPoint<?> point : points) {
            Key<?> parameterKey = point.getKey();
            Parameter parameter = (Parameter)point.getElement();
            if (parameterKey.getRawType().equals(Supplier.class)) {
                argFactories.put(parameter, () -> this.getFactory(point, node, chain, debugLog));
                continue;
            }
            Set<Key<?>> newChain = DefaultInjector.chain(chain, key);
            if (newChain.contains(parameterKey)) {
                StringBuilder sb = new StringBuilder("Circular dependency encountered: ");
                for (Key<?> chainKey : newChain) {
                    sb.append(chainKey).append(" -> ");
                }
                sb.append(parameterKey);
                throw new InjectException(sb.toString());
            }
            argFactories.put(parameter, () -> this.getFactory(point, node, newChain, debugLog).get());
        }
        return argFactories;
    }

    private Scope getScopeForMethod(Method method) {
        Annotation methodScope = AnnotationUtil.getMetaAnnotation(method, ScopeType.class);
        return methodScope != null ? this.getScope(methodScope.annotationType()) : this.getScopeForType(method.getReturnType());
    }

    private Scope getScopeForType(Class<?> type) {
        Annotation scope = AnnotationUtil.getMetaAnnotation(type, ScopeType.class);
        return scope != null ? this.getScope(scope.annotationType()) : DefaultScope.INSTANCE;
    }

    private static boolean isCompatibleValidator(Constraint constraint, Class<? extends Annotation> annotationType) {
        for (Type type : constraint.value().getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != ConstraintValidator.class || parameterizedType.getActualTypeArguments()[0] != annotationType) continue;
            return true;
        }
        return false;
    }

    private static void initializeConstraintValidator(ConstraintValidator<? extends Annotation> validator, Annotation annotation) {
        validator.initialize(annotation);
    }

    private static Type getTypeConverterSupportedType(Class<?> clazz) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != TypeConverter.class) continue;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return Void.TYPE;
    }

    private static void verifyAttributesConsumed(Node node) {
        Map<String, String> attrs = node.getAttributes();
        if (!attrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : attrs.keySet()) {
                if (sb.length() == 0) {
                    sb.append(node.getName());
                    sb.append(" contains ");
                    if (attrs.size() == 1) {
                        sb.append("an invalid element or attribute ");
                    } else {
                        sb.append("invalid attributes ");
                    }
                } else {
                    sb.append(", ");
                }
                StringBuilders.appendDqValue((StringBuilder)sb, (Object)key);
            }
            LOGGER.error(sb.toString());
        }
    }

    private static void verifyChildrenConsumed(Node node) {
        PluginType<?> type = node.getType();
        if (type != null && !type.isDeferChildren() && node.hasChildren()) {
            for (Node child : node.getChildren()) {
                String nodeType = node.getType().getElementType();
                String start = nodeType.equalsIgnoreCase(node.getName()) ? node.getName() : nodeType + " " + node.getName();
                LOGGER.error("{} has no field or parameter that matches element {}", (Object)start, (Object)child.getName());
            }
        }
    }

    private static Set<Key<?>> chain(Set<Key<?>> chain, Key<?> newKey) {
        if (chain == null || chain.isEmpty()) {
            return Set.of(newKey);
        }
        LinkedHashSet newChain = new LinkedHashSet(chain);
        newChain.add(newKey);
        return newChain;
    }

    private static <T> Constructor<T> getInjectableConstructor(Key<T> key, Set<Key<?>> chain) {
        Class<T> rawType = key.getRawType();
        List injectConstructors = Stream.of(rawType.getDeclaredConstructors()).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).collect(Collectors.toList());
        if (injectConstructors.size() > 1) {
            throw new InjectException("Multiple @Inject constructors found in " + rawType);
        }
        if (injectConstructors.size() == 1) {
            return (Constructor)TypeUtil.cast(injectConstructors.get(0));
        }
        try {
            return rawType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return rawType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                ArrayList keys = new ArrayList(chain);
                keys.add(0, key);
                String prefix = chain.isEmpty() ? "" : "chain ";
                String keysToString = prefix + keys.stream().map(Key::toString).collect(Collectors.joining(" -> "));
                throw new InjectException("No @Inject constructors or no-arg constructor found for " + keysToString);
            }
        }
    }

    private static boolean isInjectable(Field field) {
        return field.isAnnotationPresent(Inject.class) || AnnotationUtil.isMetaAnnotationPresent(field, QualifierType.class);
    }

    private static boolean isInjectable(Method method) {
        return method.isAnnotationPresent(Inject.class) || !AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class) && Stream.of(method.getParameters()).anyMatch(parameter -> AnnotationUtil.isMetaAnnotationPresent(parameter, QualifierType.class));
    }

    private static enum DefaultScope implements Scope
    {
        INSTANCE;


        @Override
        public <T> Supplier<T> get(Key<T> key, Supplier<T> unscoped) {
            return unscoped;
        }

        public String toString() {
            return "[Unscoped]";
        }
    }

    private static class SingletonScope
    implements Scope {
        private final Map<Key<?>, Supplier<?>> singletonProviders = new ConcurrentHashMap();

        private SingletonScope() {
        }

        @Override
        public <T> Supplier<T> get(Key<T> key, Supplier<T> unscoped) {
            return (Supplier)TypeUtil.cast(this.singletonProviders.computeIfAbsent(key, ignored -> new LazyValue(unscoped)));
        }

        public String toString() {
            return "[SingletonScope; size=" + this.singletonProviders.size() + "]";
        }
    }
}

