/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.convert;

import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.status.StatusLogger;

@FunctionalInterface
public interface TypeConverter<T> {
    public T convert(String var1) throws Exception;

    default public T convert(String string, Object defaultValue) {
        return this.convert(string, defaultValue, false);
    }

    default public T convert(String string, Object defaultValue, boolean sensitive) {
        if (string != null) {
            try {
                return this.convert(string);
            }
            catch (Exception e) {
                StatusLogger.getLogger().warn("Unable to convert string [{}]. Using default value [{}].", (Object)(sensitive ? "-redacted-" : string), defaultValue, (Object)e);
            }
        }
        if (defaultValue == null) {
            return null;
        }
        if (!(defaultValue instanceof String)) {
            return TypeUtil.cast(defaultValue);
        }
        try {
            return this.convert((String)defaultValue);
        }
        catch (Exception e) {
            StatusLogger.getLogger().debug("Unable to parse default value [{}].", defaultValue, (Object)e);
            return null;
        }
    }
}

