/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.Ordered;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.TypeUtil;

public class Key<T> {
    private final Type type;
    private final Class<T> rawType;
    private final Class<? extends Annotation> qualifierType;
    private final String name;
    private final String namespace;
    private final int order;
    private final int hashCode;
    private String toString;

    protected Key() {
        this.type = TypeUtil.getSuperclassTypeParameter(this.getClass());
        this.rawType = (Class)TypeUtil.cast(TypeUtil.getRawType(this.type));
        AnnotatedType superclass = this.getClass().getAnnotatedSuperclass();
        Annotation qualifier = AnnotationUtil.getMetaAnnotation(superclass, QualifierType.class);
        this.qualifierType = qualifier != null ? qualifier.annotationType() : null;
        this.name = Keys.getName(superclass);
        this.namespace = Keys.getNamespace(superclass);
        this.order = Key.getOrder(superclass);
        this.hashCode = Objects.hash(this.type, this.qualifierType, this.name.toLowerCase(Locale.ROOT), this.namespace.toLowerCase(Locale.ROOT));
    }

    private Key(Type type, Class<T> rawType, Class<? extends Annotation> qualifierType, String name, String namespace, int order) {
        this.type = type;
        this.rawType = rawType;
        this.qualifierType = qualifierType;
        this.name = name;
        this.namespace = namespace;
        this.order = order;
        this.hashCode = Objects.hash(type, qualifierType, name.toLowerCase(Locale.ROOT), namespace.toLowerCase(Locale.ROOT));
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final int getOrder() {
        return this.order;
    }

    public final Key<T> withName(String name) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, name, this.namespace, this.order);
    }

    public final Key<T> withNamespace(String namespace) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, this.name, namespace, this.order);
    }

    public final Key<T> withQualifierType(Class<? extends Annotation> qualifierType) {
        return new Key<T>(this.type, this.rawType, qualifierType, this.name, this.namespace, this.order);
    }

    public final <P> Key<P> getSuppliedType() {
        if (this.type instanceof ParameterizedType && Supplier.class.isAssignableFrom(this.rawType)) {
            return Key.forQualifiedNamedType(this.qualifierType, this.name, ((ParameterizedType)this.type).getActualTypeArguments()[0], this.namespace, this.order);
        }
        return null;
    }

    public final <P> Key<P> getParameterizedTypeArgument(int arg) {
        if (this.type instanceof ParameterizedType) {
            return Key.forQualifiedNamedType(this.qualifierType, this.name, ((ParameterizedType)this.type).getActualTypeArguments()[arg], this.namespace, this.order);
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return TypeUtil.isEqual(this.type, that.type) && this.name.equalsIgnoreCase(that.name) && this.namespace.equalsIgnoreCase(that.namespace) && Objects.equals(this.qualifierType, that.qualifierType);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        String string = this.toString;
        if (string == null) {
            this.toString = string = String.format("Key{namespace='%s', name='%s', type=%s, qualifierType=%s}", this.namespace, this.name, this.type.getTypeName(), this.qualifierType != null ? this.qualifierType.getSimpleName() : "");
        }
        return string;
    }

    public static <T> Key<T> forClass(Class<T> clazz) {
        return Key.forQualifiedNamedType(Key.getQualifierType(clazz), Keys.getName(clazz), clazz, Keys.getNamespace(clazz), Key.getOrder(clazz));
    }

    public static <T> Key<T> forMethod(Method method) {
        return Key.forQualifiedNamedType(Key.getQualifierType(method), Keys.getName(method), method.getGenericReturnType(), Keys.getNamespace(method), Key.getOrder(method));
    }

    public static <T> Key<T> forParameter(Parameter parameter) {
        return Key.forQualifiedNamedType(Key.getQualifierType(parameter), Keys.getName(parameter), parameter.getParameterizedType(), Keys.getNamespace(parameter), 0);
    }

    public static <T> Key<T> forField(Field field) {
        return Key.forQualifiedNamedType(Key.getQualifierType(field), Keys.getName(field), field.getGenericType(), Keys.getNamespace(field), 0);
    }

    private static <T> Key<T> forQualifiedNamedType(Class<? extends Annotation> qualifierType, String name, Type type, String namespace, int order) {
        Class rawType = (Class)TypeUtil.cast(TypeUtil.getRawType(type));
        return new Key<T>(type, rawType, qualifierType, name, namespace, order);
    }

    private static Class<? extends Annotation> getQualifierType(AnnotatedElement element) {
        Annotation qualifierAnnotation = AnnotationUtil.getMetaAnnotation(element, QualifierType.class);
        return qualifierAnnotation != null ? qualifierAnnotation.annotationType() : null;
    }

    private static int getOrder(AnnotatedElement element) {
        Ordered annotation = element.getAnnotation(Ordered.class);
        return annotation != null ? annotation.value() : 0;
    }
}

