/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.util;

import org.apache.logging.log4j.plugins.processor.PluginEntry;

public class PluginType<T> {
    private final PluginEntry pluginEntry;
    private volatile Class<T> pluginClass;
    private final ClassLoader classLoader;
    private final String elementName;

    public PluginType(PluginEntry pluginEntry, Class<T> pluginClass, String elementName) {
        this.pluginEntry = pluginEntry;
        this.pluginClass = pluginClass;
        this.elementName = elementName;
        this.classLoader = null;
    }

    public PluginType(PluginEntry pluginEntry, ClassLoader classLoader) {
        this.pluginEntry = pluginEntry;
        this.classLoader = classLoader;
        this.elementName = pluginEntry.getName();
        this.pluginClass = null;
    }

    public PluginEntry getPluginEntry() {
        return this.pluginEntry;
    }

    public Class<T> getPluginClass() {
        if (this.pluginClass == null) {
            try {
                this.pluginClass = this.classLoader.loadClass(this.pluginEntry.getClassName());
            }
            catch (ClassNotFoundException | LinkageError ex) {
                throw new IllegalStateException("No class named " + this.pluginEntry.getClassName() + " located for element " + this.elementName, ex);
            }
        }
        return this.pluginClass;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getKey() {
        return this.pluginEntry.getKey();
    }

    public boolean isObjectPrintable() {
        return this.pluginEntry.isPrintable();
    }

    public boolean isDeferChildren() {
        return this.pluginEntry.isDefer();
    }

    public String getCategory() {
        return this.pluginEntry.getCategory();
    }

    public String toString() {
        return "PluginType [pluginClass=" + this.pluginClass + ", key=" + this.pluginEntry.getKey() + ", elementName=" + this.pluginEntry.getName() + ", isObjectPrintable=" + this.pluginEntry.isPrintable() + ", isDeferChildren==" + this.pluginEntry.isDefer() + ", category=" + this.pluginEntry.getCategory() + "]";
    }
}

