/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.test.validation;

import java.net.InetSocketAddress;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.plugins.validation.constraints.ValidPort;

@Namespace(value="Test")
@Plugin(value="HostAndPort")
public final class HostAndPort {
    private final InetSocketAddress address;

    private HostAndPort(InetSocketAddress address) {
        this.address = address;
    }

    public boolean isValid() {
        return !this.address.isUnresolved();
    }

    @PluginFactory
    public static HostAndPort createPlugin(@ValidHost(message="Unit test (host)") @PluginAttribute String host, @ValidPort(message="Unit test (port)") @PluginAttribute int port) {
        return new HostAndPort(new InetSocketAddress(host, port));
    }

    public String toString() {
        return "HostAndPort{address=" + String.valueOf(this.address) + "}";
    }
}

