/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.env.support;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.env.PropertySource;
import org.apache.logging.log4j.kit.env.support.ClassLoaderPropertyEnvironment;
import org.jspecify.annotations.Nullable;

public class CompositePropertyEnvironment
extends ClassLoaderPropertyEnvironment {
    private final Collection<PropertySource> sources = new TreeSet<PropertySource>(Comparator.comparing(PropertySource::getPriority).reversed());

    public CompositePropertyEnvironment(@Nullable PropertyEnvironment parentEnvironment, Collection<? extends PropertySource> sources, ClassLoader loader, Logger statusLogger) {
        super(loader, statusLogger);
        this.sources.addAll(sources);
        if (parentEnvironment != null) {
            this.sources.add(new ParentEnvironmentPropertySource(parentEnvironment));
        }
    }

    @Override
    public @Nullable String getProperty(String name) {
        return this.sources.stream().map(source -> source.getProperty(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private record ParentEnvironmentPropertySource(PropertyEnvironment parentEnvironment) implements PropertySource
    {
        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        @Override
        public @Nullable String getProperty(String name) {
            return this.parentEnvironment.getProperty(name);
        }
    }
}

