/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonReader {
    private CharacterIterator it;
    private int readCharIndex = -1;
    private char readChar;
    private int readTokenStartIndex = -1;
    private Object readToken;
    private final StringBuilder buffer = new StringBuilder();

    private JsonReader() {
    }

    public static Object read(String json) {
        Objects.requireNonNull(json, "json");
        JsonReader reader = new JsonReader();
        return reader.read(new StringCharacterIterator(json));
    }

    private Object read(CharacterIterator ci) {
        this.it = ci;
        this.readCharIndex = 0;
        this.readChar = this.it.first();
        Object token = this.readToken();
        if (token instanceof Delimiter) {
            String message = String.format("was not expecting %s at index %d", this.readToken, this.readTokenStartIndex);
            throw new IllegalArgumentException(message);
        }
        this.skipWhiteSpace();
        if (this.it.getIndex() != this.it.getEndIndex()) {
            String message = String.format("was not expecting input at index %d: %c", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
        return token;
    }

    private Object readToken() {
        this.skipWhiteSpace();
        this.readTokenStartIndex = this.readCharIndex;
        char prevChar = this.readChar;
        this.readChar();
        switch (prevChar) {
            case '\"': {
                this.readToken = this.readString();
                break;
            }
            case '[': {
                this.readToken = this.readArray();
                break;
            }
            case ']': {
                this.readToken = Delimiter.ARRAY_END;
                break;
            }
            case ',': {
                this.readToken = Delimiter.COMMA;
                break;
            }
            case '{': {
                this.readToken = this.readObject();
                break;
            }
            case '}': {
                this.readToken = Delimiter.OBJECT_END;
                break;
            }
            case ':': {
                this.readToken = Delimiter.COLON;
                break;
            }
            case 't': {
                this.readToken = this.readTrue();
                break;
            }
            case 'f': {
                this.readToken = this.readFalse();
                break;
            }
            case 'n': {
                this.readToken = this.readNull();
                break;
            }
            default: {
                this.unreadChar();
                if (Character.isDigit(this.readChar) || this.readChar == '-') {
                    this.readToken = this.readNumber();
                    break;
                }
                String message = String.format("invalid character at index %d: %c", this.readCharIndex, Character.valueOf(this.readChar));
                throw new IllegalArgumentException(message);
            }
        }
        return this.readToken;
    }

    private void skipWhiteSpace() {
        boolean inComment = false;
        do {
            if (inComment) {
                if (this.readChar != '*') continue;
                if (this.readChar() == '/') {
                    inComment = false;
                    continue;
                }
                this.unreadChar();
                continue;
            }
            if (this.readChar == '/') {
                if (this.readChar() == '*') {
                    inComment = true;
                    continue;
                }
                this.unreadChar();
                continue;
            }
            if (!Character.isWhitespace(this.readChar)) break;
        } while (this.readChar() != '\uffff');
    }

    private char readChar() {
        if (this.it.getIndex() == this.it.getEndIndex()) {
            throw new IllegalArgumentException("premature end of input");
        }
        this.readChar = this.it.next();
        this.readCharIndex = this.it.getIndex();
        return this.readChar;
    }

    private void unreadChar() {
        this.readChar = this.it.previous();
        this.readCharIndex = this.it.getIndex();
    }

    private String readString() {
        this.buffer.setLength(0);
        block8: while (this.readChar != '\"') {
            if (this.readChar == '\\') {
                this.readChar();
                if (this.readChar == 'u') {
                    char unicodeChar = this.readUnicodeChar();
                    this.bufferChar(unicodeChar);
                    continue;
                }
                switch (this.readChar) {
                    case '\"': 
                    case '\\': {
                        this.bufferReadChar();
                        continue block8;
                    }
                    case 'b': {
                        this.bufferChar('\b');
                        continue block8;
                    }
                    case 'f': {
                        this.bufferChar('\f');
                        continue block8;
                    }
                    case 'n': {
                        this.bufferChar('\n');
                        continue block8;
                    }
                    case 'r': {
                        this.bufferChar('\r');
                        continue block8;
                    }
                    case 't': {
                        this.bufferChar('\t');
                        continue block8;
                    }
                }
                String message = String.format("was expecting an escape character at index %d: %c", this.readCharIndex, Character.valueOf(this.readChar));
                throw new IllegalArgumentException(message);
            }
            this.bufferReadChar();
        }
        this.readChar();
        return this.buffer.toString();
    }

    private void bufferReadChar() {
        this.bufferChar(this.readChar);
    }

    private void bufferChar(char c) {
        this.buffer.append(c);
        this.readChar();
    }

    private char readUnicodeChar() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            this.readChar();
            if (this.readChar >= '0' && this.readChar <= '9') {
                value = (value << 4) + this.readChar - 48;
                continue;
            }
            if (this.readChar >= 'a' && this.readChar <= 'f') {
                value = (value << 4) + (this.readChar - 97) + 10;
                continue;
            }
            if (this.readChar >= 'A' && this.readChar <= 'F') {
                value = (value << 4) + (this.readChar - 65) + 10;
                continue;
            }
            String message = String.format("was expecting a unicode character at index %d: %c", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
        return (char)value;
    }

    private Map<String, Object> readObject() {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        String key = this.readObjectKey();
        while (this.readToken != Delimiter.OBJECT_END) {
            this.expectDelimiter(Delimiter.COLON, this.readToken());
            if (this.readToken == Delimiter.OBJECT_END) continue;
            Object value = this.readToken();
            object.put(key, value);
            if (this.readToken() == Delimiter.COMMA) {
                key = this.readObjectKey();
                if (key != null && !Delimiter.exists(key)) continue;
                String message = String.format("was expecting an object key at index %d: %s", this.readTokenStartIndex, this.readToken);
                throw new IllegalArgumentException(message);
            }
            this.expectDelimiter(Delimiter.OBJECT_END, this.readToken);
        }
        return object;
    }

    private List<Object> readArray() {
        LinkedList<Object> array = new LinkedList<Object>();
        this.readToken();
        while (this.readToken != Delimiter.ARRAY_END) {
            if (this.readToken instanceof Delimiter) {
                String message = String.format("was expecting an array element at index %d: %s", this.readTokenStartIndex, this.readToken);
                throw new IllegalArgumentException(message);
            }
            array.add(this.readToken);
            if (this.readToken() == Delimiter.COMMA) {
                if (this.readToken() != Delimiter.ARRAY_END) continue;
                String message = String.format("was expecting an array element at index %d: %s", this.readTokenStartIndex, this.readToken);
                throw new IllegalArgumentException(message);
            }
            this.expectDelimiter(Delimiter.ARRAY_END, this.readToken);
        }
        return array;
    }

    private String readObjectKey() {
        this.readToken();
        if (this.readToken == Delimiter.OBJECT_END) {
            return null;
        }
        if (this.readToken instanceof String) {
            return (String)this.readToken;
        }
        String message = String.format("was expecting an object key at index %d: %s", this.readTokenStartIndex, this.readToken);
        throw new IllegalArgumentException(message);
    }

    private void expectDelimiter(Delimiter expectedDelimiter, Object actualToken) {
        if (!expectedDelimiter.equals(actualToken)) {
            String message = String.format("was expecting %s at index %d: %s", new Object[]{expectedDelimiter, this.readTokenStartIndex, actualToken});
            throw new IllegalArgumentException(message);
        }
    }

    private boolean readTrue() {
        if (this.readChar != 'r' || this.readChar() != 'u' || this.readChar() != 'e') {
            String message = String.format("was expecting keyword 'true' at index %d: %s", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
        this.readChar();
        return true;
    }

    private boolean readFalse() {
        if (this.readChar != 'a' || this.readChar() != 'l' || this.readChar() != 's' || this.readChar() != 'e') {
            String message = String.format("was expecting keyword 'false' at index %d: %s", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
        this.readChar();
        return false;
    }

    private Object readNull() {
        if (this.readChar != 'u' || this.readChar() != 'l' || this.readChar() != 'l') {
            String message = String.format("was expecting keyword 'null' at index %d: %s", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
        this.readChar();
        return null;
    }

    private Number readNumber() {
        this.buffer.setLength(0);
        if (this.readChar == '-') {
            this.bufferReadChar();
        }
        boolean floatingPoint = false;
        this.bufferDigits();
        if (this.readChar == '.') {
            this.bufferReadChar();
            this.bufferDigits();
            floatingPoint = true;
        }
        if (this.readChar == 'e' || this.readChar == 'E') {
            floatingPoint = true;
            this.bufferReadChar();
            if (this.readChar == '+' || this.readChar == '-') {
                this.bufferReadChar();
            }
            this.bufferDigits();
        }
        String string = this.buffer.toString();
        if (floatingPoint) {
            return new BigDecimal(string);
        }
        BigInteger bigInteger = new BigInteger(string);
        try {
            return bigInteger.intValueExact();
        }
        catch (ArithmeticException ignoredIntOverflow) {
            try {
                return bigInteger.longValueExact();
            }
            catch (ArithmeticException ignoredLongOverflow) {
                return bigInteger;
            }
        }
    }

    private void bufferDigits() {
        boolean found = false;
        while (Character.isDigit(this.readChar)) {
            found = true;
            this.bufferReadChar();
        }
        if (!found) {
            String message = String.format("was expecting a digit at index %d: %c", this.readCharIndex, Character.valueOf(this.readChar));
            throw new IllegalArgumentException(message);
        }
    }

    private static enum Delimiter {
        OBJECT_START("{"),
        OBJECT_END("}"),
        ARRAY_START("["),
        ARRAY_END("]"),
        COLON(":"),
        COMMA(",");

        private final String string;

        private Delimiter(String string2) {
            this.string = string2;
        }

        private static boolean exists(Object token) {
            for (Delimiter delimiter : Delimiter.values()) {
                if (!delimiter.string.equals(token)) continue;
                return true;
            }
            return false;
        }
    }
}

