/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.DefaultLevelConverter;
import org.apache.logging.log4j.jul.LevelConverter;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class LevelTranslator {
    public static final Level FINEST = Level.forName((String)"FINEST", (int)(Level.TRACE.intLevel() + 100));
    public static final Level CONFIG = Level.forName((String)"CONFIG", (int)(Level.INFO.intLevel() + 50));
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final LevelConverter LEVEL_CONVERTER;

    public static Level toLevel(java.util.logging.Level level) {
        return LEVEL_CONVERTER.toLevel(level);
    }

    public static java.util.logging.Level toJavaLevel(Level level) {
        return LEVEL_CONVERTER.toJavaLevel(level);
    }

    private LevelTranslator() {
    }

    static {
        String levelConverterClassName = PropertiesUtil.getProperties().getStringProperty("log4j.jul.levelConverter");
        if (levelConverterClassName != null) {
            LevelConverter levelConverter;
            try {
                levelConverter = (LevelConverter)LoaderUtil.newCheckedInstanceOf((String)levelConverterClassName, LevelConverter.class);
            }
            catch (Exception e) {
                LOGGER.error("Could not create custom LevelConverter [{}].", new Object[]{levelConverterClassName, e});
                levelConverter = new DefaultLevelConverter();
            }
            LEVEL_CONVERTER = levelConverter;
        } else {
            LEVEL_CONVERTER = new DefaultLevelConverter();
        }
    }
}

