/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Properties;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ContextAwarePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.ReloadablePropertySource;

@ServiceProvider(value=PropertySource.class, resolution="optional")
public class EnvironmentPropertySource
extends ContextAwarePropertySource
implements ReloadablePropertySource {
    private static final int DEFAULT_PRIORITY = 100;

    @Override
    public int getPriority() {
        return 100;
    }

    public EnvironmentPropertySource() {
        super(System.getenv());
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        Properties properties = (Properties)this.propertiesMap.get("*");
        if (properties == null) {
            return;
        }
        for (String key : properties.stringPropertyNames()) {
            action.accept(key, properties.getProperty(key));
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : tokens) {
            if (sb.length() > 0) {
                sb.append('_');
            }
            sb.append(charSequence);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Override
    public void reload() {
        this.propertiesMap.putAll(this.parseProperties(System.getenv()));
    }
}

