/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.internal.QueueFactories;
import org.apache.logging.log4j.internal.QueueingRecyclerFactory;
import org.apache.logging.log4j.internal.StringParameterParser;
import org.apache.logging.log4j.internal.ThreadLocalRecyclerFactory;
import org.apache.logging.log4j.spi.DummyRecyclerFactory;
import org.apache.logging.log4j.spi.QueueFactory;
import org.apache.logging.log4j.spi.RecyclerFactory;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.InternalApi;

@InternalApi
public final class RecyclerFactories {
    public static final int CAPACITY = Math.max(2 * Runtime.getRuntime().availableProcessors() + 1, 8);
    public static final RecyclerFactory INSTANCE = Constants.isThreadLocalsEnabled() ? new ThreadLocalRecyclerFactory(CAPACITY) : new QueueingRecyclerFactory(QueueFactories.MPMC, CAPACITY);

    private RecyclerFactories() {
    }

    public static RecyclerFactory ofSpec(String recyclerFactorySpec) {
        Objects.requireNonNull(recyclerFactorySpec, "recyclerFactorySpec");
        if (recyclerFactorySpec.equals("dummy")) {
            return DummyRecyclerFactory.getInstance();
        }
        if (recyclerFactorySpec.startsWith("threadLocal")) {
            return RecyclerFactories.readThreadLocalRecyclerFactory(recyclerFactorySpec);
        }
        if (recyclerFactorySpec.startsWith("queue")) {
            return RecyclerFactories.readQueueingRecyclerFactory(recyclerFactorySpec);
        }
        throw new IllegalArgumentException("invalid recycler factory: " + recyclerFactorySpec);
    }

    private static RecyclerFactory readThreadLocalRecyclerFactory(String recyclerFactorySpec) {
        String queueFactorySpec = recyclerFactorySpec.substring("threadLocal".length() + (recyclerFactorySpec.startsWith("threadLocal:") ? 1 : 0));
        Map<String, StringParameterParser.Value> parsedValues = StringParameterParser.parse(queueFactorySpec, Set.of("capacity"));
        int capacity = RecyclerFactories.readQueueCapacity(queueFactorySpec, parsedValues);
        return new ThreadLocalRecyclerFactory(capacity);
    }

    private static RecyclerFactory readQueueingRecyclerFactory(String recyclerFactorySpec) {
        String queueFactorySpec = recyclerFactorySpec.substring("queue".length() + (recyclerFactorySpec.startsWith("queue:") ? 1 : 0));
        Map<String, StringParameterParser.Value> parsedValues = StringParameterParser.parse(queueFactorySpec, Set.of("supplier", "capacity"));
        int capacity = RecyclerFactories.readQueueCapacity(queueFactorySpec, parsedValues);
        StringParameterParser.Value supplierValue = parsedValues.get("supplier");
        String supplierPath = supplierValue == null || supplierValue instanceof StringParameterParser.NullValue ? null : supplierValue.toString();
        QueueFactory queueFactory = supplierPath != null ? QueueFactories.ofSupplier(supplierPath) : QueueFactories.MPMC;
        return new QueueingRecyclerFactory(queueFactory, capacity);
    }

    private static int readQueueCapacity(String factorySpec, Map<String, StringParameterParser.Value> parsedValues) {
        int capacity;
        StringParameterParser.Value capacityValue = parsedValues.get("capacity");
        if (capacityValue == null || capacityValue instanceof StringParameterParser.NullValue) {
            return CAPACITY;
        }
        try {
            capacity = Integer.parseInt(capacityValue.toString());
        }
        catch (NumberFormatException error) {
            throw new IllegalArgumentException("failed reading `capacity` in recycler factory: " + factorySpec, error);
        }
        if (capacity < 1) {
            throw new IllegalArgumentException("was expecting `capacity > 0` in the recycler factory: " + factorySpec);
        }
        return capacity;
    }
}

