/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.spi.AbstractRecycler;
import org.apache.logging.log4j.spi.QueueFactory;
import org.apache.logging.log4j.spi.Recycler;
import org.apache.logging.log4j.spi.RecyclerFactory;

final class QueueingRecyclerFactory
implements RecyclerFactory {
    private final QueueFactory queueFactory;
    private final int capacity;

    QueueingRecyclerFactory(QueueFactory queueFactory, int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("was expecting `capacity > 0`, found: " + capacity);
        }
        this.queueFactory = Objects.requireNonNull(queueFactory, "queueFactory");
        this.capacity = capacity;
    }

    int getCapacity() {
        return this.capacity;
    }

    @Override
    public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(cleaner, "cleaner");
        Queue queue = this.queueFactory.create(this.capacity);
        return new QueueingRecycler<V>(supplier, cleaner, queue);
    }

    static class QueueingRecycler<V>
    extends AbstractRecycler<V> {
        private final Consumer<V> cleaner;
        private final Queue<V> queue;

        private QueueingRecycler(Supplier<V> supplier, Consumer<V> cleaner, Queue<V> queue) {
            super(supplier);
            this.cleaner = cleaner;
            this.queue = queue;
        }

        Queue<V> getQueue() {
            return this.queue;
        }

        @Override
        public V acquire() {
            V value = this.queue.poll();
            return value != null ? value : this.createInstance();
        }

        @Override
        public void release(V value) {
            Objects.requireNonNull(value, "value");
            this.cleaner.accept(value);
            this.queue.offer(value);
        }
    }
}

