/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Supplier;
import org.apache.logging.log4j.spi.QueueFactory;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.SpscArrayQueue;

@InternalApi
public enum QueueFactories implements QueueFactory
{
    SPSC(() -> SpscArrayQueue::new),
    MPMC(() -> MpmcArrayQueue::new);

    private final QueueFactory queueFactory;

    private QueueFactories(Supplier<QueueFactory> queueFactoryProvider) {
        this.queueFactory = QueueFactories.getOrReplaceQueueFactory(queueFactoryProvider);
    }

    private static QueueFactory getOrReplaceQueueFactory(Supplier<QueueFactory> queueFactoryProvider) {
        try {
            QueueFactory queueFactory = queueFactoryProvider.get();
            queueFactory.create(16);
            return queueFactory;
        }
        catch (LinkageError ignored) {
            return ArrayBlockingQueueFactory.INSTANCE;
        }
    }

    @Override
    public <E> Queue<E> create(int capacity) {
        return this.queueFactory.create(capacity);
    }

    public static QueueFactory ofSupplier(String supplierPath) {
        int supplierPathSplitterIndex = supplierPath.lastIndexOf(46);
        if (supplierPathSplitterIndex < 0) {
            String message = String.format("invalid queue factory supplier path: `%s`", supplierPath);
            throw new IllegalArgumentException(message);
        }
        String supplierClassName = supplierPath.substring(0, supplierPathSplitterIndex);
        String supplierMethodName = supplierPath.substring(supplierPathSplitterIndex + 1);
        try {
            Class<?> supplierClass = LoaderUtil.loadClass(supplierClassName);
            if ("new".equals(supplierMethodName)) {
                Constructor<?> supplierCtor = supplierClass.getDeclaredConstructor(Integer.TYPE);
                return new ConstructorProvidedQueueFactory(supplierCtor);
            }
            Method supplierMethod = supplierClass.getMethod(supplierMethodName, Integer.TYPE);
            return new StaticMethodProvidedQueueFactory(supplierMethod);
        }
        catch (LinkageError | ReflectiveOperationException | SecurityException error) {
            String message = String.format("failed to create the queue factory using the supplier path `%s`", supplierPath);
            throw new RuntimeException(message, error);
        }
    }

    private static final class ArrayBlockingQueueFactory
    implements QueueFactory {
        private static final ArrayBlockingQueueFactory INSTANCE = new ArrayBlockingQueueFactory();

        private ArrayBlockingQueueFactory() {
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            return new ArrayBlockingQueue(capacity);
        }
    }

    private static final class ConstructorProvidedQueueFactory
    implements QueueFactory {
        private final Constructor<?> constructor;

        private ConstructorProvidedQueueFactory(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            Constructor typedConstructor = (Constructor)Cast.cast(this.constructor);
            try {
                return (Queue)typedConstructor.newInstance(capacity);
            }
            catch (ReflectiveOperationException error) {
                throw new RuntimeException("queue construction failure", error);
            }
        }
    }

    private static final class StaticMethodProvidedQueueFactory
    implements QueueFactory {
        private final Method method;

        private StaticMethodProvidedQueueFactory(Method method) {
            this.method = method;
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            try {
                return (Queue)Cast.cast(this.method.invoke(null, capacity));
            }
            catch (ReflectiveOperationException error) {
                throw new RuntimeException("queue construction failure", error);
            }
        }
    }
}

