/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.internal.RecyclerFactories;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.CopyOnWriteSortedArrayThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.spi.GarbageFreeSortedArrayThreadContextMap;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.spi.NoOpThreadContextMap;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.RecyclerFactory;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.spi.ThreadContextStack;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

@ServiceConsumer(value=Provider.class)
public class LoggingSystem {
    private static final String PROVIDER_RESOURCE = "META-INF/log4j-provider.properties";
    private static final String API_VERSION = "Log4jAPIVersion";
    private static final String[] COMPATIBLE_API_VERSIONS = new String[]{"3.0.0"};
    public static final int THREAD_CONTEXT_DEFAULT_INITIAL_CAPACITY = 16;
    private static final Lazy<LoggingSystem> SYSTEM = Lazy.relaxed(LoggingSystem::new);
    private final Lazy<SystemProvider> providerLazy = Lazy.relaxed(this::findProvider);
    private final Lazy<PropertyEnvironment> environmentLazy = Lazy.relaxed(PropertiesUtil::getProperties);
    private final Lazy<LoggerContextFactory> loggerContextFactoryLazy = this.environmentLazy.map(environment -> this.getProvider().createLoggerContextFactory((PropertyEnvironment)environment));
    private final Lazy<MessageFactory> messageFactoryLazy = this.environmentLazy.map(environment -> {
        MessageFactory factory;
        String className = environment.getStringProperty(LoggingSystemProperty.LOGGER_MESSAGE_FACTORY_CLASS);
        if (className != null && (factory = LoggingSystem.createInstance(className, MessageFactory.class)) != null) {
            return factory;
        }
        return Constants.isThreadLocalsEnabled() ? new ReusableMessageFactory() : new ParameterizedMessageFactory();
    });
    private final Lazy<FlowMessageFactory> flowMessageFactoryLazy = this.environmentLazy.map(environment -> {
        FlowMessageFactory factory;
        String className = environment.getStringProperty(LoggingSystemProperty.LOGGER_FLOW_MESSAGE_FACTORY_CLASS);
        if (className != null && (factory = LoggingSystem.createInstance(className, FlowMessageFactory.class)) != null) {
            return factory;
        }
        return new DefaultFlowMessageFactory();
    });
    private final Lazy<Supplier<ThreadContextMap>> threadContextMapFactoryLazy = this.environmentLazy.map(environment -> () -> this.getProvider().createContextMap((PropertyEnvironment)environment));
    private final Lazy<Supplier<ThreadContextStack>> threadContextStackFactoryLazy = this.environmentLazy.map(environment -> () -> this.getProvider().createContextStack((PropertyEnvironment)environment));
    private final Lazy<RecyclerFactory> recyclerFactoryLazy = Lazy.lazy(() -> RecyclerFactories.INSTANCE);

    private SystemProvider getProvider() {
        return this.providerLazy.get();
    }

    private SystemProvider findProvider() {
        TreeMap<Integer, Provider> providers = new TreeMap<Integer, Provider>();
        LoggingSystem.loadDefaultProviders().forEach(p -> providers.put(p.getPriority(), (Provider)p));
        LoggingSystem.loadLegacyProviders().forEach(p -> providers.put(p.getPriority(), (Provider)p));
        if (providers.isEmpty()) {
            return new SystemProvider();
        }
        Provider provider = (Provider)providers.get(providers.lastKey());
        if (providers.size() > 1) {
            StringBuilder sb = new StringBuilder("Multiple logging implementations found: \n");
            providers.forEach((i, p) -> sb.append(p).append('\n'));
            sb.append("Using ").append(provider);
            LowLevelLogUtil.log(sb.toString());
        }
        return new SystemProvider(provider);
    }

    public void setLoggerContextFactory(LoggerContextFactory loggerContextFactory) {
        this.loggerContextFactoryLazy.set(loggerContextFactory);
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactoryLazy.set(messageFactory);
    }

    public void setFlowMessageFactory(FlowMessageFactory flowMessageFactory) {
        this.flowMessageFactoryLazy.set(flowMessageFactory);
    }

    public void setThreadContextMapFactory(Supplier<ThreadContextMap> threadContextMapFactory) {
        this.threadContextMapFactoryLazy.set(threadContextMapFactory);
    }

    public void setThreadContextStackFactory(Supplier<ThreadContextStack> threadContextStackFactory) {
        this.threadContextStackFactoryLazy.set(threadContextStackFactory);
    }

    public void setRecyclerFactory(RecyclerFactory factory) {
        this.recyclerFactoryLazy.set(factory);
    }

    public static LoggingSystem getInstance() {
        return SYSTEM.get();
    }

    public static LoggerContextFactory getLoggerContextFactory() {
        return LoggingSystem.getInstance().loggerContextFactoryLazy.get();
    }

    public static MessageFactory getMessageFactory() {
        return LoggingSystem.getInstance().messageFactoryLazy.get();
    }

    public static FlowMessageFactory getFlowMessageFactory() {
        return LoggingSystem.getInstance().flowMessageFactoryLazy.get();
    }

    public static ThreadContextMap createContextMap() {
        return LoggingSystem.getInstance().threadContextMapFactoryLazy.get().get();
    }

    public static ThreadContextStack createContextStack() {
        return LoggingSystem.getInstance().threadContextStackFactoryLazy.get().get();
    }

    public static RecyclerFactory getRecyclerFactory() {
        return LoggingSystem.getInstance().recyclerFactoryLazy.get();
    }

    private static List<Provider> loadDefaultProviders() {
        return ServiceLoaderUtil.safeStream(ServiceLoader.load(Provider.class, Provider.class.getClassLoader())).filter(provider -> LoggingSystem.validVersion(provider.getVersions())).collect(Collectors.toList());
    }

    private static List<Provider> loadLegacyProviders() {
        return LoaderUtil.findUrlResources(PROVIDER_RESOURCE).stream().map(urlResource -> LoggingSystem.loadLegacyProvider(urlResource.getUrl(), urlResource.getClassLoader())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Provider loadLegacyProvider(URL url, ClassLoader classLoader) {
        Properties properties = new Properties();
        try (InputStream in = url.openStream();){
            properties.load(in);
        }
        catch (IOException e) {
            LowLevelLogUtil.logException("Unable to load file " + url, e);
            return null;
        }
        if (LoggingSystem.validVersion(properties.getProperty(API_VERSION))) {
            return new Provider(properties, url, classLoader);
        }
        return null;
    }

    private static boolean validVersion(String version) {
        for (String v : COMPATIBLE_API_VERSIONS) {
            if (!version.startsWith(v)) continue;
            return true;
        }
        return false;
    }

    private static <T> T tryInstantiate(Class<T> clazz) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (!constructor.canAccess(null) && !constructor.trySetAccessible()) {
                    LowLevelLogUtil.log("Unable to access constructor for " + clazz);
                    return null;
                }
            }
            catch (NoSuchMethodException e) {
                LowLevelLogUtil.logException("Unable to find a default constructor for " + clazz, e);
                return null;
            }
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            LowLevelLogUtil.logException("Exception thrown by constructor for " + clazz, e.getCause());
        }
        catch (InstantiationException | LinkageError e) {
            LowLevelLogUtil.logException("Unable to create instance of " + clazz, e);
        }
        catch (IllegalAccessException e) {
            LowLevelLogUtil.logException("Unable to access constructor for " + clazz, e);
        }
        return null;
    }

    private static <T> T createInstance(String className, Class<T> type) {
        try {
            Class<?> loadedClass = LoaderUtil.loadClass(className);
            Class<T> typedClass = loadedClass.asSubclass(type);
            return LoggingSystem.tryInstantiate(typedClass);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            LowLevelLogUtil.logException(String.format("Unable to load %s class '%s'", type.getSimpleName(), className), e);
            return null;
        }
    }

    private static final class SystemProvider {
        private final Provider provider;

        private SystemProvider() {
            this(null);
        }

        private SystemProvider(Provider provider) {
            this.provider = provider;
        }

        public LoggerContextFactory createLoggerContextFactory(PropertyEnvironment environment) {
            LoggerContextFactory factory;
            Class<? extends LoggerContextFactory> factoryClass;
            LoggerContextFactory customFactory;
            String customFactoryClass = environment.getStringProperty(LoggingSystemProperty.LOGGER_CONTEXT_FACTORY_CLASS);
            if (customFactoryClass != null && (customFactory = LoggingSystem.createInstance(customFactoryClass, LoggerContextFactory.class)) != null) {
                return customFactory;
            }
            if (this.provider != null && (factoryClass = this.provider.loadLoggerContextFactory()) != null && (factory = LoggingSystem.tryInstantiate(factoryClass)) != null) {
                return factory;
            }
            LowLevelLogUtil.log("Log4j could not find a logging implementation. Please add log4j-core dependencies to classpath or module path. Using SimpleLogger to log to the console.");
            return SimpleLoggerContextFactory.INSTANCE;
        }

        public ThreadContextMap createContextMap(PropertyEnvironment environment) {
            ThreadContextMap map;
            ThreadContextMap customContextMap;
            String customThreadContextMap = environment.getStringProperty(LoggingSystemProperty.THREAD_CONTEXT_MAP_CLASS);
            if (customThreadContextMap != null && (customContextMap = LoggingSystem.createInstance(customThreadContextMap, ThreadContextMap.class)) != null) {
                return customContextMap;
            }
            boolean enableMap = environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_MAP_ENABLED, environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_ENABLE, true));
            if (!enableMap) {
                return new NoOpThreadContextMap();
            }
            Class<? extends ThreadContextMap> mapClass = this.provider.loadThreadContextMap();
            if (mapClass != null && (map = LoggingSystem.tryInstantiate(mapClass)) != null) {
                return map;
            }
            boolean threadLocalsEnabled = Constants.isThreadLocalsEnabled();
            boolean garbageFreeEnabled = environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_GARBAGE_FREE_ENABLED);
            boolean inheritableMap = environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_MAP_INHERITABLE);
            int initialCapacity = environment.getIntegerProperty(LoggingSystemProperty.THREAD_CONTEXT_INITIAL_CAPACITY, 16);
            if (threadLocalsEnabled) {
                if (garbageFreeEnabled) {
                    return new GarbageFreeSortedArrayThreadContextMap(inheritableMap, initialCapacity);
                }
                return new CopyOnWriteSortedArrayThreadContextMap(inheritableMap, initialCapacity);
            }
            return new DefaultThreadContextMap(true, inheritableMap);
        }

        public ThreadContextStack createContextStack(PropertyEnvironment environment) {
            boolean enableStack = environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_STACK_ENABLED, environment.getBooleanProperty(LoggingSystemProperty.THREAD_CONTEXT_ENABLE, true));
            return new DefaultThreadContextStack(enableStack);
        }
    }
}

