/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.internal.QueueFactories;
import org.apache.logging.log4j.spi.AbstractRecycler;
import org.apache.logging.log4j.spi.Recycler;
import org.apache.logging.log4j.spi.RecyclerFactory;

final class ThreadLocalRecyclerFactory
implements RecyclerFactory {
    private final int capacity;

    ThreadLocalRecyclerFactory(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("was expecting a `capacity` greater than 1, found: " + capacity);
        }
        this.capacity = capacity;
    }

    int getCapacity() {
        return this.capacity;
    }

    @Override
    public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(cleaner, "cleaner");
        return new ThreadLocalRecycler<V>(supplier, cleaner, this.capacity);
    }

    static class ThreadLocalRecycler<V>
    extends AbstractRecycler<V> {
        private final Consumer<V> cleaner;
        private final ThreadLocal<Queue<V>> holder = ThreadLocal.withInitial(() -> QueueFactories.SPSC.create(capacity));

        private ThreadLocalRecycler(Supplier<V> supplier, Consumer<V> cleaner, int capacity) {
            super(supplier);
            this.cleaner = cleaner;
        }

        @Override
        public V acquire() {
            Queue<V> queue = this.holder.get();
            V value = queue.poll();
            return value != null ? value : this.createInstance();
        }

        @Override
        public void release(V value) {
            Objects.requireNonNull(value, "value");
            this.cleaner.accept(value);
            this.holder.get().offer(value);
        }

        Queue<V> getQueue() {
            return this.holder.get();
        }
    }
}

