/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.QueueFactory;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.SpmcArrayQueue;
import org.jctools.queues.SpscArrayQueue;

@InternalApi
public enum QueueFactories {
    SPSC(Lazy.lazy(JCToolsQueueFactory.SPSC::load)),
    MPSC(Lazy.lazy(JCToolsQueueFactory.MPSC::load)),
    SPMC(Lazy.lazy(JCToolsQueueFactory.SPMC::load)),
    MPMC(Lazy.lazy(JCToolsQueueFactory.MPMC::load));

    private final Lazy<BoundedQueueFactory> queueFactory;

    private QueueFactories(Lazy<BoundedQueueFactory> queueFactory) {
        this.queueFactory = queueFactory;
    }

    public QueueFactory factory(int capacity) {
        return new ProxyQueueFactory(this.queueFactory.get(), capacity);
    }

    public <E> Queue<E> create(int capacity) {
        return this.queueFactory.get().create(capacity);
    }

    public static QueueFactory createQueueFactory(String supplierPath, int capacity) {
        int supplierPathSplitterIndex = supplierPath.lastIndexOf(46);
        if (supplierPathSplitterIndex < 0) {
            String message = String.format("invalid queue factory supplier path: `%s`", supplierPath);
            throw new IllegalArgumentException(message);
        }
        String supplierClassName = supplierPath.substring(0, supplierPathSplitterIndex);
        String supplierMethodName = supplierPath.substring(supplierPathSplitterIndex + 1);
        try {
            BoundedQueueFactory queueFactory;
            Class<?> supplierClass = LoaderUtil.loadClass(supplierClassName);
            if ("new".equals(supplierMethodName)) {
                Constructor<?> supplierCtor = supplierClass.getDeclaredConstructor(Integer.TYPE);
                queueFactory = new ConstructorProvidedQueueFactory(supplierCtor);
            } else {
                Method supplierMethod = supplierClass.getMethod(supplierMethodName, Integer.TYPE);
                queueFactory = new StaticMethodProvidedQueueFactory(supplierMethod);
            }
            return new ProxyQueueFactory(queueFactory, capacity);
        }
        catch (LinkageError | ReflectiveOperationException | SecurityException error) {
            String message = String.format("failed to create the queue factory using the supplier path `%s`", supplierPath);
            throw new RuntimeException(message, error);
        }
    }

    private static final class ProxyQueueFactory
    implements QueueFactory {
        private final BoundedQueueFactory factory;
        private final int capacity;

        private ProxyQueueFactory(BoundedQueueFactory factory, int capacity) {
            this.factory = factory;
            this.capacity = capacity;
        }

        @Override
        public <E> Queue<E> create() {
            return this.factory.create(this.capacity);
        }
    }

    @FunctionalInterface
    private static interface BoundedQueueFactory {
        public <E> Queue<E> create(int var1);
    }

    private static final class ConstructorProvidedQueueFactory
    implements BoundedQueueFactory {
        private final Constructor<?> constructor;

        private ConstructorProvidedQueueFactory(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            Constructor typedConstructor = (Constructor)Cast.cast(this.constructor);
            try {
                return (Queue)typedConstructor.newInstance(capacity);
            }
            catch (ReflectiveOperationException error) {
                throw new RuntimeException("queue construction failure", error);
            }
        }
    }

    private static final class StaticMethodProvidedQueueFactory
    implements BoundedQueueFactory {
        private final Method method;

        private StaticMethodProvidedQueueFactory(Method method) {
            this.method = method;
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            try {
                return (Queue)Cast.cast(this.method.invoke(null, capacity));
            }
            catch (ReflectiveOperationException error) {
                throw new RuntimeException("queue construction failure", error);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum JCToolsQueueFactory implements BoundedQueueFactory
    {
        SPSC{

            @Override
            public <E> Queue<E> create(int capacity) {
                return new SpscArrayQueue(capacity);
            }
        }
        ,
        MPSC{

            @Override
            public <E> Queue<E> create(int capacity) {
                return new MpscArrayQueue(capacity);
            }
        }
        ,
        SPMC{

            @Override
            public <E> Queue<E> create(int capacity) {
                return new SpmcArrayQueue(capacity);
            }
        }
        ,
        MPMC{

            @Override
            public <E> Queue<E> create(int capacity) {
                return new MpmcArrayQueue(capacity);
            }
        };


        private BoundedQueueFactory load() {
            try {
                this.create(16);
                return this;
            }
            catch (LinkageError ignored) {
                return ArrayBlockingQueueFactory.INSTANCE;
            }
        }
    }

    private static final class ArrayBlockingQueueFactory
    implements BoundedQueueFactory {
        private static final ArrayBlockingQueueFactory INSTANCE = new ArrayBlockingQueueFactory();

        private ArrayBlockingQueueFactory() {
        }

        @Override
        public <E> Queue<E> create(int capacity) {
            return new ArrayBlockingQueue(capacity);
        }
    }
}

