/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.InternalApi;

@InternalApi
public final class LowLevelLogUtil {
    private static ErrorLogger errorLogger = new StandardErrorLogger();
    private static final ThreadLocal<Boolean> guard = ThreadLocal.withInitial(() -> false);

    public static void setLogger(Logger logger) {
        errorLogger = new DelegateErrorLogger(logger);
    }

    public static void log(String message) {
        if (guard.get().booleanValue()) {
            return;
        }
        guard.set(true);
        try {
            if (message != null) {
                errorLogger.error(message);
            }
        }
        finally {
            guard.set(false);
        }
    }

    @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"}, justification="Log4j prints stacktraces only to logs, which should be private.")
    public static void logException(Throwable exception) {
        if (guard.get().booleanValue()) {
            return;
        }
        guard.set(true);
        try {
            if (exception != null) {
                errorLogger.error(exception);
            }
        }
        finally {
            guard.set(false);
        }
    }

    public static void logException(String message, Throwable exception) {
        if (guard.get().booleanValue()) {
            return;
        }
        guard.set(true);
        try {
            errorLogger.error(message, exception);
        }
        finally {
            guard.set(false);
        }
    }

    private LowLevelLogUtil() {
    }

    private static final class DelegateErrorLogger
    implements ErrorLogger {
        private final Logger logger;

        private DelegateErrorLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void error(String message) {
            this.logger.error(message);
        }

        @Override
        public void error(Throwable throwable) {
            this.logger.error("", throwable);
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.logger.error(message, throwable);
        }
    }

    private static class StandardErrorLogger
    implements ErrorLogger {
        private final PrintWriter stderr = new PrintWriter(System.err, true);

        private StandardErrorLogger() {
        }

        @Override
        public void error(String message) {
            this.stderr.println("ERROR: " + message);
        }

        @Override
        public void error(Throwable throwable) {
            throwable.printStackTrace(this.stderr);
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.error(message);
            this.error(throwable);
        }
    }

    static interface ErrorLogger {
        public void error(String var1);

        public void error(Throwable var1);

        public void error(String var1, Throwable var2);
    }
}

