/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.internal.CopyOnWriteNavigableSet;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.ContextAwarePropertySource;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.JsonReader;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.ReloadablePropertySource;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.util.Supplier;

@InternalApi
@ServiceConsumer(value=PropertySource.class, cardinality="multiple")
public class PropertiesUtil
implements PropertyEnvironment {
    private static final String LOG4J_NAMESPACE = "component";
    private static final String LOG4J_CONTEXT_PREFIX = "log4j2.context.";
    private static final String DELIMITER = ".";
    private static final String META_INF = "META-INF/";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "log4j2.system.properties";
    private static final Lazy<List<PropertySource>> SERVICE_PROPERTY_SOURCES = Lazy.lazy(() -> ServiceLoaderUtil.safeStream(ServiceLoader.load(PropertySource.class, PropertiesUtil.class.getClassLoader())).collect(Collectors.toList()));
    private static final Lazy<PropertiesUtil> COMPONENT_PROPERTIES = Lazy.lazy(PropertiesUtil::new);
    private static final ThreadLocal<PropertiesUtil> environments = new InheritableThreadLocal<PropertiesUtil>();
    private final Environment environment;
    private final Lock reloadLock = new ReentrantLock();

    public PropertiesUtil(Properties props) {
        this(new PropertiesPropertySource(props));
    }

    public PropertiesUtil(Properties props, boolean includeInvalid) {
        this(new PropertiesPropertySource(props, "*", 200, includeInvalid));
    }

    public PropertiesUtil(String propertiesFileName) {
        this("*", propertiesFileName);
    }

    public PropertiesUtil(String contextName, String propertiesFileName) {
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        if (propertiesFileName.endsWith(".json") || propertiesFileName.endsWith(".jsn")) {
            PropertySource source = PropertiesUtil.getJsonPropertySource(propertiesFileName, 50);
            if (source != null) {
                sources.add(source);
            }
        } else {
            Properties properties = PropertyFilePropertySource.loadPropertiesFile(propertiesFileName);
            PropertiesPropertySource source = new PropertiesPropertySource(properties, null, 60, true);
            sources.add(source);
        }
        this.environment = new Environment(contextName, sources);
    }

    private PropertiesUtil() {
        this.environment = PropertiesUtil.getEnvironment(LOG4J_NAMESPACE);
    }

    public PropertiesUtil(PropertySource source) {
        List<PropertySource> sources = Collections.singletonList(source);
        this.environment = new Environment("*", sources);
    }

    private PropertiesUtil(String contextName, List<PropertySource> sources) {
        this.environment = new Environment(contextName, sources);
    }

    public static boolean hasThreadProperties() {
        return environments.get() != null;
    }

    public static void setThreadProperties(PropertiesUtil properties) {
        environments.set(properties);
    }

    public static void clearThreadProperties() {
        environments.remove();
    }

    public static PropertiesUtil getProperties() {
        PropertiesUtil props = environments.get();
        if (props != null) {
            return props;
        }
        return COMPONENT_PROPERTIES.get();
    }

    public static PropertyEnvironment getProperties(String namespace) {
        return PropertiesUtil.getEnvironment(namespace);
    }

    private static Environment getEnvironment(String namespace) {
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        String fileName = String.format("log4j2.%s.properties", namespace);
        Properties properties = PropertyFilePropertySource.loadPropertiesFile(fileName);
        PropertySource source = new PropertiesPropertySource(properties, 50);
        sources.add(source);
        source = PropertiesUtil.getJsonPropertySource(String.format("log4j2.%s.json", namespace), 60);
        if (source != null) {
            sources.add(source);
        }
        return new Environment("*", sources);
    }

    public static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    @Override
    public void addPropertySource(PropertySource propertySource) {
        if (this.environment != null) {
            this.environment.addPropertySource(propertySource);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        return this.environment.hasProperty(name);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    @Override
    public Boolean getBooleanProperty(String[] prefixes, String key, Supplier<Boolean> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getBooleanProperty(prefix + key);
        }
        return supplier != null ? (Boolean)supplier.get() : null;
    }

    @Override
    public Charset getCharsetProperty(String name) {
        return this.getCharsetProperty(name, Charset.defaultCharset());
    }

    @Override
    public Charset getCharsetProperty(String name, Charset defaultValue) {
        String mapped;
        String charsetName = this.getStringProperty(name);
        if (charsetName == null) {
            return defaultValue;
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        ResourceBundle bundle = PropertiesUtil.getCharsetsResourceBundle();
        if (bundle.containsKey(name) && Charset.isSupported(mapped = bundle.getString(name))) {
            return Charset.forName(mapped);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + charsetName + "' for property '" + name + "', using default " + defaultValue + " and continuing.");
        return defaultValue;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Double.parseDouble(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getIntegerProperty(String name, int defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Integer.parseInt(prop.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Integer getIntegerProperty(String[] prefixes, String key, Supplier<Integer> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getIntegerProperty(prefix + key, 0);
        }
        return supplier != null ? (Integer)supplier.get() : null;
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Long getLongProperty(String[] prefixes, String key, Supplier<Long> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getLongProperty(prefix + key, 0L);
        }
        return supplier != null ? (Long)supplier.get() : null;
    }

    @Override
    public Duration getDurationProperty(String name, Duration defaultValue) {
        String prop = this.getStringProperty(name);
        if (prop != null) {
            return TimeUnit.getDuration(prop);
        }
        return defaultValue;
    }

    @Override
    public Duration getDurationProperty(String[] prefixes, String key, Supplier<Duration> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key)) continue;
            return this.getDurationProperty(prefix + key, null);
        }
        return supplier != null ? (Duration)supplier.get() : null;
    }

    @Override
    public String getStringProperty(String[] prefixes, String key, Supplier<String> supplier) {
        for (String prefix : prefixes) {
            String result = this.getStringProperty(prefix + key);
            if (result == null) continue;
            return result;
        }
        return supplier != null ? (String)supplier.get() : null;
    }

    @Override
    public String getStringProperty(String name) {
        return this.environment.getStringProperty(name);
    }

    public void reload() {
        this.reloadLock.lock();
        try {
            this.environment.reload();
        }
        finally {
            this.reloadLock.unlock();
        }
    }

    public static PropertiesUtil getContextProperties(String contextName) {
        return PropertiesUtil.getContextProperties(contextName, PropertiesUtil.getProperties());
    }

    public static PropertiesUtil getContextProperties(String contextName, PropertiesUtil propertiesUtil) {
        ClassLoader classLoader = PropertiesUtil.class.getClassLoader();
        String filePrefix = "META-INF/log4j2." + contextName + DELIMITER;
        ArrayList<PropertySource> contextSources = new ArrayList<PropertySource>();
        contextSources.addAll(PropertiesUtil.getContextPropertySources(classLoader, filePrefix, contextName));
        contextSources.addAll(propertiesUtil.environment.sources);
        return new PropertiesUtil(contextName, contextSources);
    }

    public static PropertiesUtil getContextProperties(ClassLoader classLoader, String contextName) {
        Object filePrefix = "META-INF/log4j2." + contextName + DELIMITER;
        ArrayList<PropertySource> contextSources = new ArrayList<PropertySource>(PropertiesUtil.getContextPropertySources(classLoader, (String)filePrefix, contextName));
        filePrefix = "META-INF/log4j2.context.";
        contextSources.addAll(PropertiesUtil.getContextPropertySources(classLoader, (String)filePrefix, contextName));
        contextSources.addAll(PropertiesUtil.getProperties().environment.sources);
        return new PropertiesUtil(contextName, contextSources);
    }

    private static List<PropertySource> getContextPropertySources(ClassLoader classLoader, String filePrefix, String contextName) {
        InputStream is;
        URL url;
        Enumeration<URL> urls;
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        String fileName = filePrefix + "json";
        try {
            urls = classLoader.getResources(fileName);
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                try {
                    is = url.openStream();
                    try {
                        String json = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                        PropertySource propertySource = PropertiesUtil.parseJsonProperties(json, contextName, 110);
                        sources.add(propertySource);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception ex) {
                    LowLevelLogUtil.logException("Unable to parse JSON for " + url.toString(), ex);
                }
            }
        }
        catch (Exception ex) {
            LowLevelLogUtil.logException("Unable to access " + fileName, ex);
        }
        fileName = filePrefix + "properties";
        try {
            urls = classLoader.getResources(fileName);
            while (urls.hasMoreElements()) {
                url = urls.nextElement();
                try {
                    is = url.openStream();
                    try {
                        Properties props = new Properties();
                        props.load(is);
                        PropertiesPropertySource source = new PropertiesPropertySource(props, contextName, 120);
                        sources.add(source);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception ex) {
                    LowLevelLogUtil.logException("Unable to access properties for " + url.toString(), ex);
                }
            }
        }
        catch (Exception ex) {
            LowLevelLogUtil.logException("Unable to access " + fileName, ex);
        }
        return sources;
    }

    private static PropertySource getJsonPropertySource(String fileName, int priority) {
        if (fileName.startsWith("file://")) {
            PropertySource propertySource;
            block28: {
                URL url = new URL(fileName);
                InputStream is = url.openStream();
                try {
                    propertySource = PropertiesUtil.parseJsonProperties(new String(is.readAllBytes(), StandardCharsets.UTF_8), "*", priority);
                    if (is == null) break block28;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        LowLevelLogUtil.logException("Unable to read " + fileName, ex);
                    }
                }
                is.close();
            }
            return propertySource;
        } else {
            File file = new File(fileName);
            if (file.exists()) {
                PropertySource propertySource;
                FileInputStream is = new FileInputStream(file);
                try {
                    propertySource = PropertiesUtil.parseJsonProperties(new String(is.readAllBytes(), StandardCharsets.UTF_8), "*", priority);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        LowLevelLogUtil.logException("Unable to read " + fileName, ioe);
                    }
                }
                is.close();
                return propertySource;
            } else {
                for (URL url : LoaderUtil.findResources(fileName)) {
                    PropertySource propertySource;
                    block29: {
                        InputStream in = url.openStream();
                        try {
                            propertySource = PropertiesUtil.parseJsonProperties(new String(in.readAllBytes(), StandardCharsets.UTF_8), "*", priority);
                            if (in == null) break block29;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LowLevelLogUtil.logException("Unable to read " + url, e);
                            }
                        }
                        in.close();
                    }
                    return propertySource;
                }
            }
        }
        return null;
    }

    private static PropertySource parseJsonProperties(String json, String contextName, int priority) {
        Map root = (Map)Cast.cast(JsonReader.read(json));
        Properties props = new Properties();
        PropertiesUtil.populateProperties(props, "", root);
        return new PropertiesPropertySource(props, contextName, priority);
    }

    private static void populateProperties(Properties props, String prefix, Map<String, Object> root) {
        if (!root.isEmpty()) {
            for (Map.Entry<String, Object> entry : root.entrySet()) {
                if (entry.getValue() instanceof String) {
                    props.setProperty(PropertiesUtil.createKey(prefix, entry.getKey()), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    StringBuilder sb = new StringBuilder();
                    List entries = (List)Cast.cast(entry.getValue());
                    entries.forEach(obj -> {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(obj.toString());
                    });
                    props.setProperty(PropertiesUtil.createKey(prefix, entry.getKey()), sb.toString());
                    continue;
                }
                PropertiesUtil.populateProperties(props, PropertiesUtil.createKey(prefix, entry.getKey()), (Map)Cast.cast(entry.getValue()));
            }
        }
    }

    private static String createKey(String prefix, String suffix) {
        if (prefix.isEmpty()) {
            return suffix;
        }
        return prefix + DELIMITER + suffix;
    }

    public static Properties extractSubset(Properties properties, String prefix) {
        Properties subset = new Properties();
        if (Strings.isEmpty(prefix)) {
            return subset;
        }
        Object prefixToMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + DELIMITER : prefix;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith((String)prefixToMatch)) continue;
            subset.setProperty(key.substring(((String)prefixToMatch).length()), properties.getProperty(key));
            keys.add(key);
        }
        for (String key : keys) {
            properties.remove(key);
        }
        return subset;
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        return PropertiesUtil.partitionOnCommonPrefixes(properties, false);
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties, boolean includeBaseKey) {
        ConcurrentHashMap<String, Properties> parts = new ConcurrentHashMap<String, Properties>();
        for (String key : properties.stringPropertyNames()) {
            int idx = key.indexOf(46);
            if (idx < 0) {
                if (!includeBaseKey) continue;
                if (!parts.containsKey(key)) {
                    parts.put(key, new Properties());
                }
                ((Properties)parts.get(key)).setProperty("", properties.getProperty(key));
                continue;
            }
            String prefix = key.substring(0, idx);
            if (!parts.containsKey(prefix)) {
                parts.put(prefix, new Properties());
            }
            ((Properties)parts.get(prefix)).setProperty(key.substring(idx + 1), properties.getProperty(key));
        }
        return parts;
    }

    @Override
    public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }

    private static enum TimeUnit {
        NANOS("ns,nano,nanos,nanosecond,nanoseconds", ChronoUnit.NANOS),
        MICROS("us,micro,micros,microsecond,microseconds", ChronoUnit.MICROS),
        MILLIS("ms,milli,millis,millsecond,milliseconds", ChronoUnit.MILLIS),
        SECONDS("s,second,seconds", ChronoUnit.SECONDS),
        MINUTES("m,minute,minutes", ChronoUnit.MINUTES),
        HOURS("h,hour,hours", ChronoUnit.HOURS),
        DAYS("d,day,days", ChronoUnit.DAYS);

        private final String[] descriptions;
        private final ChronoUnit timeUnit;

        private TimeUnit(String descriptions, ChronoUnit timeUnit) {
            this.descriptions = descriptions.split(",");
            this.timeUnit = timeUnit;
        }

        static Duration getDuration(String time) {
            String value = time.trim();
            ChronoUnit temporalUnit = ChronoUnit.MILLIS;
            long timeVal = 0L;
            for (TimeUnit timeUnit : TimeUnit.values()) {
                for (String suffix : timeUnit.descriptions) {
                    if (!value.endsWith(suffix)) continue;
                    temporalUnit = timeUnit.timeUnit;
                    timeVal = Long.parseLong(value.substring(0, value.length() - suffix.length()));
                }
            }
            return Duration.of(timeVal, temporalUnit);
        }
    }

    private static final class Environment
    implements PropertyEnvironment {
        private final NavigableSet<PropertySource> sources = new CopyOnWriteNavigableSet<PropertySource>(new PropertySource.Comparator());
        private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
        private final String contextName;

        private Environment(String contextName, List<PropertySource> propertySources) {
            Properties sysProps = PropertyFilePropertySource.loadPropertiesFile(PropertiesUtil.LOG4J_SYSTEM_PROPERTIES_FILE_NAME);
            for (String key : sysProps.stringPropertyNames()) {
                if (System.getProperty(key) != null) continue;
                System.setProperty(key, sysProps.getProperty(key));
            }
            this.sources.addAll(propertySources);
            this.sources.addAll((Collection<PropertySource>)SERVICE_PROPERTY_SOURCES.get());
            this.contextName = contextName;
            this.reload();
        }

        @Override
        public void addPropertySource(PropertySource propertySource) {
            this.sources.add(propertySource);
        }

        private void reload() {
            this.literal.clear();
            this.sources.forEach(s -> {
                if (s instanceof ReloadablePropertySource) {
                    ((ReloadablePropertySource)((Object)s)).reload();
                }
            });
            HashSet keys = new HashSet();
            this.sources.stream().map(PropertySource::getPropertyNames).forEach(keys::addAll);
            keys.stream().filter(Objects::nonNull).forEach(key -> {
                String contextKey = this.getContextKey((String)key);
                if (this.contextName != null && !this.contextName.equals("*")) {
                    this.sources.forEach(source -> {
                        ContextAwarePropertySource src;
                        if (source instanceof ContextAwarePropertySource && (src = (ContextAwarePropertySource)Cast.cast(source)).containsProperty(this.contextName, contextKey)) {
                            this.literal.putIfAbsent((String)key, src.getProperty(this.contextName, contextKey));
                        }
                    });
                }
                this.sources.forEach(source -> {
                    if (source.containsProperty(contextKey)) {
                        this.literal.putIfAbsent((String)key, source.getProperty(contextKey));
                    }
                });
            });
        }

        @Override
        public String getStringProperty(String key) {
            PropertySource source;
            if (this.literal.containsKey(key)) {
                return this.literal.get(key);
            }
            String result = null;
            String contextKey = this.getContextKey(key);
            if (this.contextName != null && !this.contextName.equals("*")) {
                source = (PropertySource)this.sources.first();
                while (source != null) {
                    if (source instanceof ContextAwarePropertySource) {
                        ContextAwarePropertySource src = (ContextAwarePropertySource)Cast.cast(source);
                        result = src.getProperty(this.contextName, contextKey);
                    }
                    if (result != null) {
                        return result;
                    }
                    source = this.sources.higher(source);
                }
            }
            source = (PropertySource)this.sources.first();
            while (source != null) {
                result = source.getProperty(contextKey);
                if (result != null) {
                    return result;
                }
                source = this.sources.higher(source);
            }
            return result;
        }

        @Override
        public boolean hasProperty(String key) {
            ContextAwarePropertySource src;
            PropertySource source;
            if (this.literal.containsKey(key)) {
                return true;
            }
            String contextKey = this.getContextKey(key);
            if (!this.contextName.equals("*")) {
                source = (PropertySource)this.sources.first();
                while (source != null) {
                    if (source instanceof ContextAwarePropertySource && (src = (ContextAwarePropertySource)Cast.cast(source)).containsProperty(this.contextName, contextKey)) {
                        return true;
                    }
                    source = this.sources.higher(source);
                }
            }
            source = (PropertySource)this.sources.first();
            while (source != null) {
                if (source instanceof ContextAwarePropertySource ? (src = (ContextAwarePropertySource)Cast.cast(source)).containsProperty(this.contextName, contextKey) || !this.contextName.equals("*") && src.containsProperty("*", contextKey) : source.containsProperty(key)) {
                    return true;
                }
                source = this.sources.higher(source);
            }
            return false;
        }

        private String getContextKey(String key) {
            List<CharSequence> tokens;
            String keyToCheck = key;
            if (keyToCheck.startsWith("log4j2.") && (tokens = PropertySource.Util.tokenize(key)).size() > 3) {
                keyToCheck = PropertySource.Util.join(tokens.subList(2, tokens.size())).toString();
            }
            return keyToCheck;
        }
    }
}

