/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public class StringFormattedMessage
implements Message {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String messagePattern;
    private final Object[] argArray;
    private String formattedMessage;
    private Throwable throwable;
    private final Locale locale;

    public StringFormattedMessage(Locale locale, String messagePattern, Object ... arguments) {
        this.locale = locale;
        this.messagePattern = messagePattern;
        this.argArray = arguments;
        if (arguments != null && arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            this.throwable = (Throwable)arguments[arguments.length - 1];
        }
    }

    public StringFormattedMessage(String messagePattern, Object ... arguments) {
        this(Locale.getDefault(Locale.Category.FORMAT), messagePattern, arguments);
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.argArray);
        }
        return this.formattedMessage;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public Object[] getParameters() {
        return this.argArray;
    }

    protected String formatMessage(String msgPattern, Object ... args) {
        if (args != null && args.length == 0) {
            return msgPattern;
        }
        try {
            return String.format(this.locale, msgPattern, args);
        }
        catch (IllegalFormatException ife) {
            LOGGER.error("Unable to format msg: " + msgPattern, (Throwable)ife);
            return msgPattern;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringFormattedMessage)) {
            return false;
        }
        StringFormattedMessage that = (StringFormattedMessage)o;
        return Objects.equals(this.messagePattern, that.messagePattern) && Arrays.equals(this.argArray, that.argArray);
    }

    public int hashCode() {
        int result = Objects.hash(this.messagePattern);
        result = 31 * result + Arrays.hashCode(this.argArray);
        return result;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

