/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.LowLevelLogUtil;

@InternalApi
public final class ServiceLoaderUtil {
    private static final int MAX_BROKEN_SERVICES = 8;

    private ServiceLoaderUtil() {
    }

    public static <S> Stream<S> safeStream(ServiceLoader<S> serviceLoader) {
        HashSet classes = new HashSet();
        return StreamSupport.stream(new ServiceLoaderSpliterator<S>(serviceLoader), false).filter(service -> classes.add(service.getClass()));
    }

    private static class ServiceLoaderSpliterator<S>
    extends Spliterators.AbstractSpliterator<S> {
        private final Iterator<S> serviceIterator;
        private final String serviceName;

        private ServiceLoaderSpliterator(ServiceLoader<S> serviceLoader) {
            super(Long.MAX_VALUE, 16);
            this.serviceIterator = serviceLoader.iterator();
            this.serviceName = serviceLoader.toString();
        }

        @Override
        public boolean tryAdvance(Consumer<? super S> action) {
            int i = 8;
            while (i-- > 0) {
                try {
                    if (!this.serviceIterator.hasNext()) continue;
                    action.accept(this.serviceIterator.next());
                    return true;
                }
                catch (LinkageError | ServiceConfigurationError e) {
                    LowLevelLogUtil.logException("Unable to load implementation for " + this.serviceName, e);
                }
                catch (Throwable e) {
                    LowLevelLogUtil.logException("Unexpected exception while loading implementation for " + this.serviceName, e);
                    throw e;
                }
            }
            return false;
        }
    }
}

