/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.Clearable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.spi.LoggingSystem;
import org.apache.logging.log4j.spi.Recycler;
import org.apache.logging.log4j.spi.RecyclerFactory;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class ReusableMessageFactory
implements MessageFactory {
    public static final ReusableMessageFactory INSTANCE = new ReusableMessageFactory();
    private final Recycler<ReusableParameterizedMessage> parameterizedMessageRecycler;
    private final Recycler<ReusableSimpleMessage> simpleMessageRecycler;
    private final Recycler<ReusableObjectMessage> objectMessageRecycler;

    public ReusableMessageFactory() {
        this(LoggingSystem.getRecyclerFactory());
    }

    public ReusableMessageFactory(RecyclerFactory recyclerFactory) {
        this.parameterizedMessageRecycler = recyclerFactory.create(ReusableParameterizedMessage::new, ReusableParameterizedMessage::clear);
        this.simpleMessageRecycler = recyclerFactory.create(ReusableSimpleMessage::new, ReusableSimpleMessage::clear);
        this.objectMessageRecycler = recyclerFactory.create(ReusableObjectMessage::new, ReusableObjectMessage::clear);
    }

    public static void release(Message message) {
        if (message instanceof ReusableMessage) {
            ((ReusableMessage)message).clear();
        } else if (message instanceof Clearable) {
            ((Clearable)((Object)message)).clear();
        }
    }

    @Override
    public void recycle(Message message) {
        if (message instanceof ReusableMessage) {
            ((ReusableMessage)message).clear();
        }
        if (message instanceof ReusableParameterizedMessage) {
            this.parameterizedMessageRecycler.release((ReusableParameterizedMessage)message);
        } else if (message instanceof ReusableObjectMessage) {
            this.objectMessageRecycler.release((ReusableObjectMessage)message);
        } else if (message instanceof ReusableSimpleMessage) {
            this.simpleMessageRecycler.release((ReusableSimpleMessage)message);
        }
    }

    @Override
    public Message newMessage(CharSequence charSequence) {
        ReusableSimpleMessage result = this.simpleMessageRecycler.acquire();
        result.set(charSequence);
        return result;
    }

    @Override
    public Message newMessage(String message, Object ... params) {
        return this.parameterizedMessageRecycler.acquire().set(message, params);
    }

    @Override
    public Message newMessage(String message, Object p0) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4, p5);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4, p5, p6);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.parameterizedMessageRecycler.acquire().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public Message newMessage(String message) {
        ReusableSimpleMessage result = this.simpleMessageRecycler.acquire();
        result.set(message);
        return result;
    }

    @Override
    public Message newMessage(Object message) {
        ReusableObjectMessage result = this.objectMessageRecycler.acquire();
        result.set(message);
        return result;
    }
}

