/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.spi.DummyRecyclerFactory;
import org.apache.logging.log4j.spi.QueueingRecyclerFactory;
import org.apache.logging.log4j.spi.RecyclerFactory;
import org.apache.logging.log4j.spi.ThreadLocalRecyclerFactory;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.QueueFactories;
import org.apache.logging.log4j.util.QueueFactory;
import org.apache.logging.log4j.util.StringParameterParser;

public final class RecyclerFactories {
    static final int DEFAULT_QUEUE_CAPACITY = Math.max(2 * Runtime.getRuntime().availableProcessors() + 1, 8);

    private RecyclerFactories() {
    }

    public static RecyclerFactory getDefault() {
        return Constants.isThreadLocalsEnabled() ? new ThreadLocalRecyclerFactory(DEFAULT_QUEUE_CAPACITY) : new QueueingRecyclerFactory(QueueFactories.MPMC.factory(DEFAULT_QUEUE_CAPACITY));
    }

    public static RecyclerFactory ofSpec(String recyclerFactorySpec) {
        if (recyclerFactorySpec == null) {
            return RecyclerFactories.getDefault();
        }
        if (recyclerFactorySpec.equals("dummy")) {
            return DummyRecyclerFactory.getInstance();
        }
        if (recyclerFactorySpec.startsWith("threadLocal")) {
            return RecyclerFactories.readThreadLocalRecyclerFactory(recyclerFactorySpec);
        }
        if (recyclerFactorySpec.startsWith("queue")) {
            return RecyclerFactories.readQueueingRecyclerFactory(recyclerFactorySpec);
        }
        throw new IllegalArgumentException("invalid recycler factory: " + recyclerFactorySpec);
    }

    private static RecyclerFactory readThreadLocalRecyclerFactory(String recyclerFactorySpec) {
        String queueFactorySpec = recyclerFactorySpec.substring("threadLocal".length() + (recyclerFactorySpec.startsWith("threadLocal:") ? 1 : 0));
        Map<String, StringParameterParser.Value> parsedValues = StringParameterParser.parse(queueFactorySpec, Set.of("capacity"));
        int capacity = RecyclerFactories.readQueueCapacity(queueFactorySpec, parsedValues);
        return new ThreadLocalRecyclerFactory(capacity);
    }

    private static RecyclerFactory readQueueingRecyclerFactory(String recyclerFactorySpec) {
        String queueFactorySpec = recyclerFactorySpec.substring("queue".length() + (recyclerFactorySpec.startsWith("queue:") ? 1 : 0));
        Map<String, StringParameterParser.Value> parsedValues = StringParameterParser.parse(queueFactorySpec, Set.of("supplier", "capacity"));
        int capacity = RecyclerFactories.readQueueCapacity(queueFactorySpec, parsedValues);
        StringParameterParser.Value supplierValue = parsedValues.get("supplier");
        String supplierPath = supplierValue == null || supplierValue instanceof StringParameterParser.NullValue ? null : supplierValue.toString();
        QueueFactory queueFactory = supplierPath != null ? QueueFactories.createQueueFactory(supplierPath, capacity) : QueueFactories.MPMC.factory(capacity);
        return new QueueingRecyclerFactory(queueFactory);
    }

    private static int readQueueCapacity(String factorySpec, Map<String, StringParameterParser.Value> parsedValues) {
        StringParameterParser.Value capacityValue = parsedValues.get("capacity");
        if (capacityValue == null || capacityValue instanceof StringParameterParser.NullValue) {
            return DEFAULT_QUEUE_CAPACITY;
        }
        try {
            return Integer.parseInt(capacityValue.toString());
        }
        catch (NumberFormatException error) {
            throw new IllegalArgumentException("failed reading `capacity` in recycler factory: " + factorySpec, error);
        }
    }
}

