/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.InternalException;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

@InternalApi
public final class LoaderUtil {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static Boolean ignoreTCCL;
    private static final RuntimePermission GET_CLASS_LOADER;
    private static final boolean GET_CLASS_LOADER_DISABLED;
    static Boolean forceTcclOnly;
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER;
    private static final PrivilegedAction<ClassLoader[]> CLASSLOADER_ACCUMULATOR;

    private LoaderUtil() {
    }

    public static ClassLoader getClassLoader() {
        return LoaderUtil.getClassLoader(LoaderUtil.class, null);
    }

    public static ClassLoader getClassLoader(Class<?> class1, Class<?> class2) {
        PrivilegedAction<ClassLoader> action = () -> {
            ClassLoader referenceLoader;
            ClassLoader loader1 = class1 == null ? null : class1.getClassLoader();
            ClassLoader loader2 = class2 == null ? null : class2.getClassLoader();
            ClassLoader classLoader = referenceLoader = GET_CLASS_LOADER_DISABLED ? LoaderUtil.getThisClassLoader() : Thread.currentThread().getContextClassLoader();
            if (LoaderUtil.isChild(referenceLoader, loader1)) {
                return LoaderUtil.isChild(referenceLoader, loader2) ? referenceLoader : loader2;
            }
            return LoaderUtil.isChild(loader1, loader2) ? loader1 : loader2;
        };
        return AccessController.doPrivileged(action, null, GET_CLASS_LOADER);
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        if (loader1 != null && loader2 != null) {
            ClassLoader parent;
            for (parent = loader1.getParent(); parent != null && parent != loader2; parent = parent.getParent()) {
            }
            return parent != null;
        }
        return loader1 != null;
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (GET_CLASS_LOADER_DISABLED) {
            try {
                return LoaderUtil.getThisClassLoader();
            }
            catch (SecurityException ignored) {
                return null;
            }
        }
        return AccessController.doPrivileged(TCCL_GETTER, null, GET_CLASS_LOADER);
    }

    public static ClassLoader[] getClassLoaders() {
        return AccessController.doPrivileged(CLASSLOADER_ACCUMULATOR, null, GET_CLASS_LOADER);
    }

    private static ClassLoader getThisClassLoader() {
        return LoaderUtil.class.getClassLoader();
    }

    public static boolean isClassAvailable(String className) {
        try {
            LoaderUtil.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException | LinkageError e) {
            return false;
        }
        catch (Throwable e) {
            LowLevelLogUtil.logException("Unknown error checking for existence of class: " + className, e);
            return false;
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = LoaderUtil.isIgnoreTccl() ? LoaderUtil.getThisClassLoader() : LoaderUtil.getThreadContextClassLoader();
        if (classLoader == null) {
            classLoader = LoaderUtil.getThisClassLoader();
        }
        return Class.forName(className, true, classLoader);
    }

    public static Class<?> loadClassUnchecked(String className) {
        try {
            return LoaderUtil.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            NoClassDefFoundError error = new NoClassDefFoundError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public static <T> T newInstanceOf(Class<T> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T newInstanceOfUnchecked(Class<T> clazz) {
        try {
            return LoaderUtil.newInstanceOf(clazz);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError error = new NoSuchMethodError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new InternalException(cause);
        }
        catch (InstantiationException e) {
            InstantiationError error = new InstantiationError(e.getMessage());
            error.initCause(e);
            throw error;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Class clazz = (Class)Cast.cast(LoaderUtil.loadClass(className));
        return LoaderUtil.newInstanceOf(clazz);
    }

    public static <T> T newInstanceOfUnchecked(String className) {
        Class clazz = (Class)Cast.cast(LoaderUtil.loadClassUnchecked(className));
        return LoaderUtil.newInstanceOfUnchecked(clazz);
    }

    public static <T> T newCheckedInstanceOf(String className, Class<T> clazz) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        return LoaderUtil.newInstanceOf(LoaderUtil.loadClass(className).asSubclass(clazz));
    }

    public static <T> T newInstanceOfUnchecked(String className, Class<T> supertype) {
        Class<T> clazz = LoaderUtil.loadClassUnchecked(className).asSubclass(supertype);
        return LoaderUtil.newInstanceOfUnchecked(clazz);
    }

    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            String ignoreTccl = PropertiesUtil.getProperties().getStringProperty(LoggingSystemProperty.LOADER_IGNORE_THREAD_CONTEXT_LOADER, null);
            ignoreTCCL = ignoreTccl != null && !"false".equalsIgnoreCase(ignoreTccl.trim());
        }
        return ignoreTCCL;
    }

    private static boolean isForceTccl() {
        if (forceTcclOnly == null) {
            String key = LoggingSystemProperty.LOADER_FORCE_THREAD_CONTEXT_LOADER.getSystemKey();
            SecurityManager securityManager = System.getSecurityManager();
            try {
                if (securityManager != null) {
                    securityManager.checkPropertyAccess(key);
                }
                forceTcclOnly = Boolean.getBoolean(key);
            }
            catch (SecurityException se) {
                forceTcclOnly = false;
            }
        }
        return forceTcclOnly;
    }

    public static Collection<URL> findResources(String resource) {
        Collection<UrlResource> urlResources = LoaderUtil.findUrlResources(resource);
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>(urlResources.size());
        for (UrlResource urlResource : urlResources) {
            resources.add(urlResource.getUrl());
        }
        return resources;
    }

    public static Collection<UrlResource> findUrlResources(String resource) {
        LinkedHashSet<UrlResource> resources = new LinkedHashSet<UrlResource>();
        for (ClassLoader cl : LoaderUtil.getClassLoaders()) {
            if (cl == null) continue;
            try {
                Enumeration<URL> resourceEnum = cl.getResources(resource);
                while (resourceEnum.hasMoreElements()) {
                    resources.add(new UrlResource(cl, resourceEnum.nextElement()));
                }
            }
            catch (IOException e) {
                LowLevelLogUtil.logException(e);
            }
        }
        return resources;
    }

    static {
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
        TCCL_GETTER = new ThreadContextClassLoaderGetter();
        CLASSLOADER_ACCUMULATOR = new ClassLoaderAccumulator();
        if (System.getSecurityManager() != null) {
            boolean getClassLoaderDisabled;
            try {
                AccessController.checkPermission(GET_CLASS_LOADER);
                getClassLoaderDisabled = false;
            }
            catch (SecurityException ignored) {
                try {
                    AccessController.doPrivileged(() -> {
                        AccessController.checkPermission(GET_CLASS_LOADER);
                        return null;
                    }, null, GET_CLASS_LOADER);
                    getClassLoaderDisabled = false;
                }
                catch (SecurityException ignore) {
                    getClassLoaderDisabled = true;
                }
            }
            GET_CLASS_LOADER_DISABLED = getClassLoaderDisabled;
        } else {
            GET_CLASS_LOADER_DISABLED = false;
        }
    }

    public static class UrlResource {
        private final ClassLoader classLoader;
        private final URL url;

        public UrlResource(ClassLoader classLoader, URL url) {
            this.classLoader = classLoader;
            this.url = url;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlResource that = (UrlResource)o;
            return Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hashCode(this.classLoader) + Objects.hashCode(this.url);
        }
    }

    private static class ClassLoaderAccumulator
    implements PrivilegedAction<ClassLoader[]> {
        private ClassLoaderAccumulator() {
        }

        @Override
        public ClassLoader[] run() {
            LinkedHashSet<ClassLoader> classLoaders;
            block4: {
                ModuleLayer layer;
                block3: {
                    classLoaders = new LinkedHashSet<ClassLoader>();
                    ClassLoader tcl = TCCL_GETTER.run();
                    if (tcl != null) {
                        classLoaders.add(tcl);
                    }
                    if ((layer = LoaderUtil.class.getModule().getLayer()) != null) break block3;
                    if (LoaderUtil.isForceTccl()) break block4;
                    ClassLoaderAccumulator.accumulateClassLoaders(LoaderUtil.getThisClassLoader(), classLoaders);
                    ClassLoaderAccumulator.accumulateClassLoaders(tcl == null ? null : tcl.getParent(), classLoaders);
                    ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                    if (systemClassLoader == null) break block4;
                    classLoaders.add(systemClassLoader);
                    break block4;
                }
                ClassLoaderAccumulator.accumulateLayerClassLoaders(layer, classLoaders);
                if (layer != ModuleLayer.boot()) {
                    for (Module module : ModuleLayer.boot().modules()) {
                        ClassLoaderAccumulator.accumulateClassLoaders(module.getClassLoader(), classLoaders);
                    }
                }
            }
            return classLoaders.toArray(EMPTY_CLASS_LOADER_ARRAY);
        }

        private static void accumulateLayerClassLoaders(ModuleLayer layer, Collection<ClassLoader> classLoaders) {
            for (Module module : layer.modules()) {
                ClassLoaderAccumulator.accumulateClassLoaders(module.getClassLoader(), classLoaders);
            }
            if (!layer.parents().isEmpty()) {
                for (ModuleLayer parent : layer.parents()) {
                    ClassLoaderAccumulator.accumulateLayerClassLoaders(parent, classLoaders);
                }
            }
        }

        private static void accumulateClassLoaders(ClassLoader loader, Collection<ClassLoader> loaders) {
            if (loader != null && loaders.add(loader)) {
                ClassLoaderAccumulator.accumulateClassLoaders(loader.getParent(), loaders);
            }
        }
    }

    private static class ThreadContextClassLoaderGetter
    implements PrivilegedAction<ClassLoader> {
        private ThreadContextClassLoaderGetter() {
        }

        @Override
        public ClassLoader run() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
            ClassLoader thisClassLoader = LoaderUtil.getThisClassLoader();
            if (thisClassLoader != null || GET_CLASS_LOADER_DISABLED) {
                return thisClassLoader;
            }
            return ClassLoader.getSystemClassLoader();
        }
    }
}

