/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.LoggingSystem;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.InternalApi;
import org.apache.logging.log4j.util.ServiceRegistry;
import org.osgi.annotation.bundle.Header;
import org.osgi.annotation.bundle.Headers;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;

@InternalApi
@Headers(value={@Header(name="Bundle-Activator", value="${@class}"), @Header(name="Bundle-ActivationPolicy", value="lazy")})
public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private boolean hasLoggingSystemInitializationLock;

    private static void checkPermission(Permission permission) {
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkPermission(permission);
        }
    }

    private void loadProvider(Bundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        try {
            Activator.checkPermission((Permission)new AdminPermission(bundle, "resource"));
            Activator.checkPermission((Permission)new AdaptPermission(BundleWiring.class.getName(), bundle, "adapt"));
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                LOGGER.debug("Bundle {} has no context (state={}), skipping loading provider", (Object)bundle.getSymbolicName(), (Object)this.toStateString(bundle.getState()));
            } else {
                this.loadProvider(bundleContext, (BundleWiring)bundle.adapt(BundleWiring.class));
            }
        }
        catch (SecurityException e) {
            LOGGER.debug("Cannot access bundle [{}] contents. Ignoring.", (Object)bundle.getSymbolicName(), (Object)e);
        }
        catch (Exception e) {
            LOGGER.warn("Problem checking bundle {} for Log4j 2 provider.", (Object)bundle.getSymbolicName(), (Object)e);
        }
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return Integer.toString(state);
    }

    private void loadProvider(BundleContext bundleContext, BundleWiring bundleWiring) {
        List<Provider> providers = this.loadProviders(bundleWiring);
        if (!providers.isEmpty()) {
            ServiceRegistry.getInstance().registerBundleServices(Provider.class, bundleContext.getBundle().getBundleId(), providers);
            if (this.hasLoggingSystemInitializationLock) {
                LoggingSystem.getInstance().releaseInitializationLock();
                this.hasLoggingSystemInitializationLock = false;
            }
        }
    }

    private List<Provider> loadProviders(BundleWiring bundleWiring) {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Iterator<Provider> iterator = ServiceLoader.load(Provider.class, classLoader).iterator();
        while (iterator.hasNext()) {
            try {
                providers.add(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                LOGGER.error("Unable to load Log4j Provider", (Throwable)e);
            }
        }
        return providers;
    }

    public void start(BundleContext bundleContext) throws Exception {
        LoggingSystem system = LoggingSystem.getInstance();
        system.acquireInitializationLock();
        this.hasLoggingSystemInitializationLock = true;
        bundleContext.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.loadProvider(event.getBundle());
                break;
            }
            case 4: {
                ServiceRegistry.getInstance().unregisterBundleServices(event.getBundle().getBundleId());
                break;
            }
        }
    }
}

