/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import org.apache.logging.log4j.spi.PropertyComponent;
import org.apache.logging.log4j.util.PropertyKey;

public enum LoggingSystemProperty implements PropertyKey
{
    GC_REUSABLE_MESSAGE_MAX_SIZE(PropertyComponent.GC, "maxReusableMsgSize"),
    THREAD_LOCALS_ENABLE(PropertyComponent.THREAD_LOCALs, "enable"),
    LOADER_IGNORE_THREAD_CONTEXT_LOADER(PropertyComponent.LOADER, "ignoreTCL"),
    LOADER_FORCE_THREAD_CONTEXT_LOADER(PropertyComponent.LOADER, "forceTCLOnly"),
    LOGGER_CONTEXT_FACTORY_CLASS(PropertyComponent.LOGGER_CONTEXT, "factory"),
    LOGGER_MESSAGE_FACTORY_CLASS(PropertyComponent.MESSAGE, "factory"),
    LOGGER_FLOW_MESSAGE_FACTORY_CLASS(PropertyComponent.MESSAGE, "flowMessageFactory"),
    LOGGER_MAP_MESSAGE_JSON_FORMATTER_MAX_DEPTH(PropertyComponent.MESSAGE, "jsonFormatterMaxDepth"),
    SIMPLE_SHOW_CONTEXT_MAP(PropertyComponent.SIMPLE_LOGGER, "showContextMap"),
    SIMPLE_SHOW_LOG_NAME(PropertyComponent.SIMPLE_LOGGER, "showLogName"),
    SIMPLE_SHOW_SHORT_LOG_NAME(PropertyComponent.SIMPLE_LOGGER, "showShortLogName"),
    SIMPLE_SHOW_DATE_TIME(PropertyComponent.SIMPLE_LOGGER, "showDateTime"),
    SIMPLE_DATE_TIME_FORMAT(PropertyComponent.SIMPLE_LOGGER, "dateTimeFormat"),
    SIMPLE_LOG_FILE(PropertyComponent.SIMPLE_LOGGER, "logFile"),
    SIMPLE_LOG_LEVEL(PropertyComponent.SIMPLE_LOGGER, "logLevel"),
    STATUS_MAX_ENTRIES(PropertyComponent.STATUS_LOGGER, "entries"),
    STATUS_DEFAULT_LISTENER_LEVEL(PropertyComponent.STATUS_LOGGER, "listenerLevel"),
    STATUS_DATE_FORMAT(PropertyComponent.STATUS_LOGGER, "dateTimeFormat"),
    STATUS_LOGGER_DEBUG(PropertyComponent.STATUS_LOGGER, "debug"),
    THREAD_CONTEXT_MAP_ENABLED(PropertyComponent.THREAD_CONTEXT, "enableMap"),
    THREAD_CONTEXT_STACK_ENABLED(PropertyComponent.THREAD_CONTEXT, "enableStack"),
    THREAD_CONTEXT_ENABLE(PropertyComponent.THREAD_CONTEXT, "enable"),
    THREAD_CONTEXT_MAP_INHERITABLE(PropertyComponent.THREAD_CONTEXT, "mapInheritable"),
    THREAD_CONTEXT_MAP_CLASS(PropertyComponent.THREAD_CONTEXT, "mapClass"),
    THREAD_CONTEXT_INITIAL_CAPACITY(PropertyComponent.THREAD_CONTEXT, "initialCapcity"),
    THREAD_CONTEXT_GARBAGE_FREE_ENABLED(PropertyComponent.THREAD_CONTEXT, "garbageFree"),
    UNBOX_RING_BUFFER_SIZE(PropertyComponent.GC, "unboxRingBufferSize"),
    IS_WEBAPP(PropertyComponent.WEB, "isWebApp");

    public static final String SIMPLE_LOGGER_LOG_LEVEL = "SimpleLogger.%s.level";
    public static final String SYSTEM_PROPERTY_PREFIX = "log4j2.*.";
    private final PropertyComponent component;
    private final String name;
    private final String key;
    private final String systemKey;

    private LoggingSystemProperty(PropertyComponent component, String name) {
        this.component = component;
        this.name = name;
        this.key = component.getName() + "." + name;
        this.systemKey = SYSTEM_PROPERTY_PREFIX + this.key;
    }

    public static LoggingSystemProperty findKey(String component, String name) {
        String toFind = component + "." + name;
        for (LoggingSystemProperty property : LoggingSystemProperty.values()) {
            if (!property.key.equals(toFind)) continue;
            return property;
        }
        return null;
    }

    @Override
    public String getComponent() {
        return this.component.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getSystemKey() {
        return this.systemKey;
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    public static class Constant {
        private static final String DELIM = ".";
        static final String DEBUG = "debug";
        public static String SYSTEM_DEBUG = "log4j2.*.System.debug";
        static final String IS_WEBAPP = "isWebApp";
        public static final String WEB_IS_WEBAPP = "log4j2.*.Web.isWebApp";
        static final String ENABLE = "enable";
        public static final String THREAD_LOCALS_ENABLE = "log4j2.*.ThreadLocals.enable";
        static final String IGNORE_TCL = "ignoreTCL";
        public static final String LOADER_IGNORE_THREAD_CONTEXT_LOADER = "log4j2.*.Loader.ignoreTCL";
        static final String FORCE_TCL_ONLY = "forceTCLOnly";
        public static final String LOADER_FORCE_THREAD_CONTEXT_LOADER = "log4j2.*.Loader.forceTCLOnly";
        static final String UNBOX_RING_BUFFER_SIZE = "unboxRingBufferSize";
        public static final String GC_UNBOX_RING_BUFFER_SIZE = "log4j2.*.GC.unboxRingBufferSize";
        static final String FACTORY = "factory";
        public static final String LOGGER_CONTEXT_FACTORY_CLASS = "log4j2.*.LoggerContext.factory";
        public static final String LOGGER_MESSAGE_FACTORY_CLASS = "log4j2.*.Message.factory";
        static final String FLOW_MESSAGE_FACTORY = "flowMessageFactory";
        public static final String LOGGER_FLOW_MESSAGE_FACTORY_CLASS = "log4j2.*.Message.flowMessageFactory";
        static final String JSON_FORMATTER_MAX_DEPTH = "jsonFormatterMaxDepth";
        public static final String LOGGER_MAP_MESSAGE_JSON_FORMATTER_MAX_DEPTH = "log4j2.*.Message.jsonFormatterMaxDepth";
        static final String MAX_REUSABLE_MSG_SIZE = "maxReusableMsgSize";
        public static final String GC_REUSABLE_MESSAGE_MAX_SIZE = "log4j2.*.GC.maxReusableMsgSize";
        static final String SHOW_CONTEXT_MAP = "showContextMap";
        public static final String SIMPLE_SHOW_CONTEXT_MAP = "log4j2.*.SimpleLogger.showContextMap";
        static final String SHOW_LOG_NAME = "showLogName";
        public static final String SIMPLE_SHOW_LOG_NAME = "log4j2.*.SimpleLogger.showLogName";
        static final String SHOW_SHORT_LOG_NAME = "showShortLogName";
        public static final String SIMPLE_SHOW_SHORT_LOG_NAME = "log4j2.*.SimpleLogger.showShortLogName";
        static final String SHOW_DATE_TIME = "showDateTime";
        public static final String SIMPLE_SHOW_DATE_TIME = "log4j2.*.SimpleLogger.showDateTime";
        static final String DATE_TIME_FORMAT = "dateTimeFormat";
        public static final String SIMPLE_DATE_TIME_FORMAT = "log4j2.*.SimpleLogger.dateTimeFormat";
        static final String LOG_FILE = "logFile";
        public static final String SIMPLE_LOG_FILE = "log4j2.*.SimpleLogger.logFile";
        static final String LOG_LEVEL = "logLevel";
        public static final String SIMPLE_LOG_LEVEL = "log4j2.*.SimpleLogger.logLevel";
        public static final String SIMPLE_LOGGER_LOG_LEVEL = "SimpleLogger.%s.level";
        static final String ENTRIES = "entries";
        public static final String STATUS_MAX_ENTRIES = "log4j2.*.StatusLogger.entries";
        static final String LISTENER_LEVEL = "listenerLevel";
        public static final String STATUS_DEFAULT_LISTENER_LEVEL = "log4j2.*.StatusLogger.listenerLevel";
        public static final String STATUS_DATE_FORMAT = "log4j2.*.StatusLogger.dateTimeFormat";
        static final String ENABLE_MAP = "enableMap";
        public static final String THREAD_CONTEXT_MAP_ENABLED = "log4j2.*.ThreadContext.enableMap";
        static final String ENABLE_STACK = "enableStack";
        public static final String THREAD_CONTEXT_STACK_ENABLED = "log4j2.*.ThreadContext.enableStack";
        public static final String THREAD_CONTEXT_ENABLED = "log4j2.*.ThreadContext.enable";
        static final String MAP_INHERITABLE = "mapInheritable";
        public static final String THREAD_CONTEXT_MAP_INHERITABLE = "log4j2.*.ThreadContext.mapInheritable";
        static final String MAP_CLASS = "mapClass";
        public static final String THREAD_CONTEXT_MAP_CLASS = "log4j2.*.ThreadContext.mapClass";
        static final String INITIAL_CAPACITY = "initialCapcity";
        public static final String THREAD_CONTEXT_INITIAL_CAPACITY = "log4j2.*.ThreadContext.initialCapcity";
        static final String GARBAGE_FREE = "garbageFree";
        public static final String THREAD_CONTEXT_GARBAGE_FREE_ENABLED = "log4j2.*.ThreadContext.garbageFree";
        static final String IS_WEB_APP = "isWebApp";
        public static final String WEB = "log4j2.*.Web.isWebApp";
    }
}

