/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;

public class FormattedMessage
implements Message {
    private static final String FORMAT_SPECIFIER = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern MSG_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private final String messagePattern;
    private final Object[] argArray;
    private String formattedMessage;
    private final Throwable throwable;
    private Message message;
    private final Locale locale;

    public FormattedMessage(Locale locale, String messagePattern, Object arg) {
        this(locale, messagePattern, new Object[]{arg}, null);
    }

    public FormattedMessage(Locale locale, String messagePattern, Object arg1, Object arg2) {
        this(locale, messagePattern, new Object[]{arg1, arg2});
    }

    public FormattedMessage(Locale locale, String messagePattern, Object ... arguments) {
        this(locale, messagePattern, arguments, null);
    }

    public FormattedMessage(Locale locale, String messagePattern, Object[] arguments, Throwable throwable) {
        this.locale = locale;
        this.messagePattern = messagePattern;
        this.argArray = arguments;
        this.throwable = throwable;
    }

    public FormattedMessage(String messagePattern, Object arg) {
        this(messagePattern, new Object[]{arg}, null);
    }

    public FormattedMessage(String messagePattern, Object arg1, Object arg2) {
        this(messagePattern, new Object[]{arg1, arg2});
    }

    public FormattedMessage(String messagePattern, Object ... arguments) {
        this(messagePattern, arguments, null);
    }

    public FormattedMessage(String messagePattern, Object[] arguments, Throwable throwable) {
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.messagePattern = messagePattern;
        this.argArray = arguments;
        this.throwable = throwable;
    }

    @Override
    public String getFormat() {
        return this.messagePattern;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            if (this.message == null) {
                this.message = this.getMessage(this.messagePattern, this.argArray, this.throwable);
            }
            this.formattedMessage = this.message.getFormattedMessage();
        }
        return this.formattedMessage;
    }

    protected Message getMessage(String msgPattern, Object[] args, Throwable aThrowable) {
        try {
            MessageFormat format = new MessageFormat(msgPattern);
            Format[] formats = format.getFormats();
            if (formats.length > 0) {
                return new MessageFormatMessage(this.locale, msgPattern, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (MSG_PATTERN.matcher(msgPattern).find()) {
                return new StringFormattedMessage(this.locale, msgPattern, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ParameterizedMessage(msgPattern, args, aThrowable);
    }

    @Override
    public Object[] getParameters() {
        return this.argArray;
    }

    @Override
    public Throwable getThrowable() {
        if (this.throwable != null) {
            return this.throwable;
        }
        if (this.message == null) {
            this.message = this.getMessage(this.messagePattern, this.argArray, null);
        }
        return this.message.getThrowable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattedMessage that = (FormattedMessage)o;
        return Objects.equals(this.messagePattern, that.messagePattern) && Arrays.equals(this.argArray, that.argArray);
    }

    public int hashCode() {
        int result = Objects.hash(this.messagePattern);
        result = 31 * result + Arrays.hashCode(this.argArray);
        return result;
    }

    public String toString() {
        return this.getFormattedMessage();
    }
}

