/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.Clearable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class ReusableMessageFactory
implements MessageFactory {
    public static final ReusableMessageFactory INSTANCE = new ReusableMessageFactory();
    private final ThreadLocal<ReusableParameterizedMessage> threadLocalParameterized = new ThreadLocal();
    private final ThreadLocal<ReusableSimpleMessage> threadLocalSimpleMessage = new ThreadLocal();
    private final ThreadLocal<ReusableObjectMessage> threadLocalObjectMessage = new ThreadLocal();

    private ReusableParameterizedMessage getParameterized() {
        ReusableParameterizedMessage result = this.threadLocalParameterized.get();
        if (result == null) {
            result = new ReusableParameterizedMessage();
            this.threadLocalParameterized.set(result);
        }
        return result.reserved ? new ReusableParameterizedMessage().reserve() : result.reserve();
    }

    private ReusableSimpleMessage getSimple() {
        ReusableSimpleMessage result = this.threadLocalSimpleMessage.get();
        if (result == null) {
            result = new ReusableSimpleMessage();
            this.threadLocalSimpleMessage.set(result);
        }
        return result;
    }

    private ReusableObjectMessage getObject() {
        ReusableObjectMessage result = this.threadLocalObjectMessage.get();
        if (result == null) {
            result = new ReusableObjectMessage();
            this.threadLocalObjectMessage.set(result);
        }
        return result;
    }

    public static void release(Message message) {
        if (message instanceof ReusableMessage) {
            ((ReusableMessage)message).clear();
        } else if (message instanceof Clearable) {
            ((Clearable)((Object)message)).clear();
        }
    }

    @Override
    public Message newMessage(CharSequence charSequence) {
        ReusableSimpleMessage result = this.getSimple();
        result.set(charSequence);
        return result;
    }

    @Override
    public Message newMessage(String message, Object ... params) {
        return this.getParameterized().set(message, params);
    }

    @Override
    public Message newMessage(String message, Object p0) {
        return this.getParameterized().set(message, p0);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1) {
        return this.getParameterized().set(message, p0, p1);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return this.getParameterized().set(message, p0, p1, p2);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3) {
        return this.getParameterized().set(message, p0, p1, p2, p3);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public Message newMessage(String message) {
        ReusableSimpleMessage result = this.getSimple();
        result.set(message);
        return result;
    }

    @Override
    public Message newMessage(Object message) {
        ReusableObjectMessage result = this.getObject();
        result.set(message);
        return result;
    }
}

