/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.internal.LogManagerStatus;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.simple.SimpleLoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.Terminable;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LazyValue;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ProviderUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class LogManager {
    public static final String FACTORY_PROPERTY_NAME = "log4j2.loggerContextFactory";
    public static final String ROOT_LOGGER_NAME = "";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String FQCN = LogManager.class.getName();
    private static final LazyValue<LoggerContextFactory> PROVIDER = LazyValue.from(() -> {
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        String factoryClassName = managerProps.getStringProperty(FACTORY_PROPERTY_NAME);
        if (factoryClassName != null) {
            try {
                return LoaderUtil.newCheckedInstanceOf(factoryClassName, LoggerContextFactory.class);
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("Unable to locate configured LoggerContextFactory {}", (Object)factoryClassName);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create configured LoggerContextFactory {}", (Object)factoryClassName, (Object)ex);
            }
        }
        if (!ProviderUtil.hasProviders()) {
            LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
            return SimpleLoggerContextFactory.INSTANCE;
        }
        TreeMap<Integer, LoggerContextFactory> factories = new TreeMap<Integer, LoggerContextFactory>();
        for (Provider provider : ProviderUtil.getProviders()) {
            Class<? extends LoggerContextFactory> clazz = provider.loadLoggerContextFactory();
            if (clazz == null) continue;
            try {
                factories.put(provider.getPriority(), clazz.newInstance());
            }
            catch (Exception e) {
                LOGGER.error("Unable to create class {} specified in provider URL {}", (Object)clazz.getName(), (Object)provider.getUrl(), (Object)e);
            }
        }
        if (factories.isEmpty()) {
            LOGGER.error("Log4j2 could not find a logging implementation. Please add log4j-core to the classpath. Using SimpleLogger to log to the console...");
            return SimpleLoggerContextFactory.INSTANCE;
        }
        if (factories.size() == 1) {
            return (LoggerContextFactory)factories.get(factories.lastKey());
        }
        StringBuilder sb = new StringBuilder("Multiple logging implementations found: \n");
        for (Map.Entry entry : factories.entrySet()) {
            sb.append("Factory: ").append(((LoggerContextFactory)entry.getValue()).getClass().getName());
            sb.append(", Weighting: ").append(entry.getKey()).append('\n');
        }
        LoggerContextFactory loggerContextFactory = (LoggerContextFactory)factories.get(factories.lastKey());
        sb.append("Using factory: ").append(loggerContextFactory.getClass().getName());
        LOGGER.warn(sb.toString());
        return loggerContextFactory;
    }).map(factory -> {
        LogManagerStatus.setInitialized(true);
        return factory;
    });

    protected LogManager() {
    }

    public static boolean exists(String name) {
        return LogManager.getContext().hasLogger(name);
    }

    public static LoggerContext getContext() {
        try {
            return LogManager.getFactory().getContext(FQCN, null, null, true);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, null, null, true);
        }
    }

    public static LoggerContext getContext(boolean currentContext) {
        try {
            return LogManager.getFactory().getContext(FQCN, null, null, currentContext, null, null);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, null, null, currentContext, null, null);
        }
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext) {
        try {
            return LogManager.getFactory().getContext(FQCN, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, null, currentContext);
        }
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext) {
        try {
            return LogManager.getFactory().getContext(FQCN, loader, externalContext, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, externalContext, currentContext);
        }
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        try {
            return LogManager.getFactory().getContext(FQCN, loader, null, currentContext, configLocation, null);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, null, currentContext, configLocation, null);
        }
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation) {
        try {
            return LogManager.getFactory().getContext(FQCN, loader, externalContext, currentContext, configLocation, null);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, externalContext, currentContext, configLocation, null);
        }
    }

    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, Object externalContext, URI configLocation, String name) {
        try {
            return LogManager.getFactory().getContext(FQCN, loader, externalContext, currentContext, configLocation, name);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(FQCN, loader, externalContext, currentContext, configLocation, name);
        }
    }

    protected static LoggerContext getContext(String fqcn, boolean currentContext) {
        try {
            return LogManager.getFactory().getContext(fqcn, null, null, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(fqcn, null, null, currentContext);
        }
    }

    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        try {
            return LogManager.getFactory().getContext(fqcn, loader, null, currentContext);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(fqcn, loader, null, currentContext);
        }
    }

    protected static LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation, String name) {
        try {
            return LogManager.getFactory().getContext(fqcn, loader, null, currentContext, configLocation, name);
        }
        catch (IllegalStateException ex) {
            LOGGER.warn(ex.getMessage() + " Using SimpleLogger");
            return SimpleLoggerContextFactory.INSTANCE.getContext(fqcn, loader, null, currentContext);
        }
    }

    public static void shutdown() {
        LogManager.shutdown(false);
    }

    public static void shutdown(boolean currentContext) {
        LogManager.getFactory().shutdown(FQCN, null, currentContext, false);
    }

    public static void shutdown(boolean currentContext, boolean allContexts) {
        LogManager.getFactory().shutdown(FQCN, null, currentContext, allContexts);
    }

    public static void shutdown(LoggerContext context) {
        if (context instanceof Terminable) {
            ((Terminable)((Object)context)).terminate();
        }
    }

    public static LoggerContextFactory getFactory() {
        return PROVIDER.get();
    }

    public static void setFactory(LoggerContextFactory factory) {
        PROVIDER.set(factory);
    }

    public static Logger getFormatterLogger() {
        return LogManager.getFormatterLogger(StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getFormatterLogger(Class<?> clazz) {
        return LogManager.getLogger(clazz != null ? clazz : StackLocatorUtil.getCallerClass(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(Object value) {
        return LogManager.getLogger(value != null ? value.getClass() : StackLocatorUtil.getCallerClass(2), (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    public static Logger getFormatterLogger(String name) {
        return name == null ? LogManager.getFormatterLogger(StackLocatorUtil.getCallerClass(2)) : LogManager.getLogger(name, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
    }

    private static Class<?> callerClass(Class<?> clazz) {
        if (clazz != null) {
            return clazz;
        }
        Class<?> candidate = StackLocatorUtil.getCallerClass(3);
        if (candidate == null) {
            throw new UnsupportedOperationException("No class provided, and an appropriate one cannot be found.");
        }
        return candidate;
    }

    public static Logger getLogger() {
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(cls);
    }

    public static Logger getLogger(Class<?> clazz, MessageFactory messageFactory) {
        Class<?> cls = LogManager.callerClass(clazz);
        return LogManager.getContext(cls.getClassLoader(), false).getLogger(cls, messageFactory);
    }

    public static Logger getLogger(MessageFactory messageFactory) {
        return LogManager.getLogger(StackLocatorUtil.getCallerClass(2), messageFactory);
    }

    public static Logger getLogger(Object value) {
        return LogManager.getLogger(value != null ? value.getClass() : StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getLogger(Object value, MessageFactory messageFactory) {
        return LogManager.getLogger(value != null ? value.getClass() : StackLocatorUtil.getCallerClass(2), messageFactory);
    }

    public static Logger getLogger(String name) {
        return name != null ? LogManager.getContext(false).getLogger(name) : LogManager.getLogger(StackLocatorUtil.getCallerClass(2));
    }

    public static Logger getLogger(String name, MessageFactory messageFactory) {
        return name != null ? LogManager.getContext(false).getLogger(name, messageFactory) : LogManager.getLogger(StackLocatorUtil.getCallerClass(2), messageFactory);
    }

    protected static Logger getLogger(String fqcn, String name) {
        return LogManager.getFactory().getContext(fqcn, null, null, false).getLogger(name);
    }

    public static Logger getRootLogger() {
        return LogManager.getLogger(ROOT_LOGGER_NAME);
    }
}

