/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.function.IntSupplier;

public class LazyInt
implements IntSupplier {
    private final IntSupplier supplier;
    private volatile boolean initialized;
    private volatile int value;

    public LazyInt(IntSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAsInt() {
        boolean uninitialized = !this.initialized;
        int value = this.value;
        if (uninitialized) {
            LazyInt lazyInt = this;
            synchronized (lazyInt) {
                boolean bl = uninitialized = !this.initialized;
                if (uninitialized) {
                    this.value = value = this.supplier.getAsInt();
                    this.initialized = true;
                }
            }
        }
        return value;
    }

    public synchronized void setAsInt(int i) {
        this.initialized = false;
        this.value = i;
        this.initialized = true;
    }
}

