/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.util.LazyValue;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

public class ServiceRegistry {
    private static final Supplier<ServiceRegistry> INSTANCE = new LazyValue<ServiceRegistry>(ServiceRegistry::new);
    private final Map<Class<?>, List<?>> mainServices = new ConcurrentHashMap();
    private final Map<Long, Map<Class<?>, List<?>>> bundleServices = new ConcurrentHashMap();

    public static ServiceRegistry getInstance() {
        return INSTANCE.get();
    }

    private static <T> T cast(Object o) {
        return (T)o;
    }

    private ServiceRegistry() {
    }

    public <S> List<S> getServices(Class<S> serviceType, MethodHandles.Lookup lookup, Predicate<S> validator) {
        List services = (List)ServiceRegistry.cast(this.mainServices.computeIfAbsent(serviceType, ignored -> ServiceLoaderUtil.loadServices(serviceType, lookup).filter(validator != null ? validator : unused -> true).collect(Collectors.toList())));
        return Stream.concat(services.stream(), this.bundleServices.values().stream().flatMap(map -> {
            Stream<Object> stream = map.getOrDefault(serviceType, List.of()).stream().map(serviceType::cast);
            return validator != null ? stream.filter(validator) : stream;
        })).distinct().collect(Collectors.toCollection(ArrayList::new));
    }

    public <S> void loadServicesFromBundle(Class<S> serviceType, long bundleId, ClassLoader bundleClassLoader) {
        ArrayList<S> services = new ArrayList<S>();
        for (S service : ServiceLoader.load(serviceType, bundleClassLoader)) {
            services.add(service);
        }
        this.registerBundleServices(serviceType, bundleId, services);
    }

    public <S> void registerBundleServices(Class<S> serviceType, long bundleId, List<S> services) {
        this.bundleServices.computeIfAbsent(bundleId, ignored -> new ConcurrentHashMap()).computeIfAbsent(serviceType, ignored -> new ArrayList()).addAll((Collection)ServiceRegistry.cast(services));
    }

    public void unregisterBundleServices(long bundleId) {
        this.bundleServices.remove(bundleId);
    }
}

